/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.actions;

import java.io.File;


import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.pepstock.jem.plugin.Client;

public class SubmitAction implements IObjectActionDelegate {

	private Shell shell;
	private IResource resource;
	private IStructuredSelection sSelection;
	private IWorkbenchPart part;
	
	/**
	 * Constructor for Action1.
	 */
	public SubmitAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		shell = targetPart.getSite().getShell();
		part = targetPart;
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		sSelection = (IStructuredSelection)part.getSite().getSelectionProvider().getSelection();
		resource = (IResource) sSelection.getFirstElement();
		File f = resource.getLocation().toFile();
		try {
			String id = Client.getInstance().submit(f);
			MessageDialog.openInformation(
					shell,
					"JEM-plugin",
					"Job submitted with id: "+id);
		} catch (Exception e) {
			e.printStackTrace();
			MessageDialog.openError(
					shell,
					"JEM-plugin",
					e.getMessage());
			}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

}
