/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.actions;

import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.pepstock.jem.plugin.Client;
import org.pepstock.jem.plugin.preferences.Coordinate;
import org.pepstock.jem.plugin.preferences.PreferenceNotFoundException;
import org.pepstock.jem.plugin.views.JemViewPart;

import com.thoughtworks.xstream.XStream;

public class SelectEnvAction extends Action {

	
	private final XStream XS = new XStream();
	public final static String PREF_NODE_ENV = "envs";

	public void run() {
		ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
		if(preferences.nodeExists(PREF_NODE_ENV)){
			ISecurePreferences envs = preferences.node(PREF_NODE_ENV);
			String[] keys = envs.keys();
			ElementListSelectionDialog dialog = new ElementListSelectionDialog(getViewer().getControl().getShell(), new LabelProvider() );
			dialog.setElements(keys);
			dialog.setTitle("Select JEM environment");
			if (dialog.open() != Window.OK) {
			    return;
			}
			Object[] result = dialog.getResult();
			String env = result[0].toString(); 
			try {
				String xml;
				xml = envs.get(env,"n/a");
				Coordinate cc = (Coordinate)XS.fromXML(xml);
				try{
					String host = Client.getInstance().getCurrentHost();
					if(Client.getInstance().changeEnvironment(cc))
						if(host != null)
							MessageDialog.openInformation(getViewer().getControl().getShell(),"Information","Successfully logged off from "+host+" and logged in "+Client.getInstance().getCurrentHost());
						else
							MessageDialog.openInformation(getViewer().getControl().getShell(),"Information","Successfully logged in "+Client.getInstance().getCurrentHost());
				}catch(Exception e){
					Client.getInstance().changeEnvironment(cc);
					MessageDialog.openInformation(getViewer().getControl().getShell(),"Information","Successfully logged in "+Client.getInstance().getCurrentHost());
				}
			} catch (StorageException e) {
				MessageDialog.openError(getViewer().getControl().getShell(),"Error","Error while loading preferences, your preferences may not be loaded: "+e.getMessage());
			} catch (PreferenceNotFoundException e) {
				MessageDialog.openWarning(getViewer().getControl().getShell(),"Warning",e.getMessage());
			} catch (Exception e) {
				MessageDialog.openError(getViewer().getControl().getShell(),"Error","Error while logging into "+env+" cause: "+e.getMessage());
			}
		}else
			MessageDialog.openInformation(getViewer().getControl().getShell(), "Environments", "No Environments saved for JEM, go to preferences and add a new one.");
		partViewer.updateName();
	}

	
	private JemViewPart partViewer;
	
	public SelectEnvAction(JemViewPart partViewer) {
		this.partViewer=partViewer;
		setText("Environments List");
		setToolTipText("Select Environment");
		setImageDescriptor(PlatformUI.getWorkbench().getSharedImages()
				.getImageDescriptor(ISharedImages.IMG_ELCL_SYNCED));
	}

	public Viewer getViewer() {
		return partViewer.getViewer();
	}

}
