/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.pepstock.jem.plugin.Client;
import org.pepstock.jem.plugin.views.JemViewPart;

public class LogOutAction extends Action {

	
	public void run() {
		try {
			String host = Client.getInstance().getCurrentHost();
			Client.getInstance().logout();
			String msg = host==null?"Successfully logged off":"Successfully logged off from "+host;
			MessageDialog.openInformation(getViewer().getControl().getShell(),"Information",msg);
		} catch (Exception e) {
			MessageDialog.openError(getViewer().getControl().getShell(),"Error","Error while logout cause: "+e.getMessage());
		}
	}

	
	private JemViewPart partViewer;
	
	public LogOutAction(JemViewPart partViewer) {
		this.partViewer=partViewer;
		setText("Logout");
		setToolTipText("Logout from current environment");
		setImageDescriptor(PlatformUI.getWorkbench().getSharedImages()
				.getImageDescriptor(ISharedImages.IMG_ELCL_SYNCED_DISABLED));
	}

	public Viewer getViewer() {
		return partViewer.getViewer();
	}

}
