/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;
import org.pepstock.jem.Job;

public class InspectAction extends Action {

	protected Viewer viewer;
	private Job resource;
	private IStructuredSelection sSelection;
	
	/**
	 * Constructor for Action1.
	 */
	public InspectAction(Viewer viewer, String text) {
		this.viewer=viewer;
		setText(text);
	}

	public InspectAction(Viewer viewer) {
		this.viewer=viewer;
		setText("Inspect");
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run() {
		
		sSelection = (IStructuredSelection)viewer.getSelection();
		resource = (Job) sSelection.getFirstElement();
		if(resource==null)
			return;
		String content = resource.getJcl().getContent();
		File file;
		BufferedWriter out=null;
		try {
			file = File.createTempFile(resource.getName(), "xml");
			out = new BufferedWriter(new FileWriter(file));
			out.write(content);
			out.close();
			IFileStore ifs = EFS.getLocalFileSystem().getStore(new Path(file.getParentFile().getAbsolutePath()));
			ifs = ifs.getChild(file.getName());
			Workbench instance = Workbench.getInstance();
			IWorkbenchWindow activeWorkbenchWindow = instance.getActiveWorkbenchWindow();
			IDE.openEditorOnFileStore(activeWorkbenchWindow.getActivePage(),ifs);

		} catch (Exception e) {
			if(out!=null)
				try {
					out.close();
				} catch (IOException e1) {
					e1.printStackTrace();
				}
			e.printStackTrace();
			MessageDialog.openError(viewer.getControl().getShell(), "JEM-Plugin", e.getMessage());
		}
	}

}
