/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Simone "Busy" Businaro
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.server.swarm.executors;

import java.io.Serializable;
import java.util.concurrent.Callable;

import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.swarm.SwarmNodeMessage;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.node.Queues;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;

/**
 * @author Simone "Busy" Businaro
 * @version 1.0
 * 
 */
public class RouterOut implements Callable<Boolean>, Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * The routed job
	 */
	private Job job = null;

	/**
	 * 
	 * @param job
	 *            the routing job
	 * @param routingEnvironment
	 *            the routing environment
	 */
	public RouterOut(Job job) {
		this.job = job;
	}

	/**
	 * Create a pre job from routed job, collect routing data to put in job than
	 * submit the prejob to the CHECKING QUEUE.
	 * 
	 * @throws Exception
	 */
	@Override
	public Boolean call() throws Exception {
		HazelcastInstance hazelcastInstance = SharedObjects.getInstance()
				.getLocalMember();
		if (hazelcastInstance == null
				|| !hazelcastInstance.getLifecycleService().isRunning())
			throw new Exception(SwarmNodeMessage.JEMO008E.toMessage()
					.getFormattedMessage(job));
		IMap<String, Job> routedQueue = hazelcastInstance
				.getMap(Queues.ROUTED_QUEUE);
		// if job is in wating mode than add job to ROUTED QUEUE
		if(!job.isNowait()){
			routedQueue.put(job.getRoutingInfo().getId(), job);
			LogAppl.getInstance().emit(SwarmNodeMessage.JEMO013I, job);			
		}
		// gets topic object and adds itself as listener
		ITopic<Job> topic = hazelcastInstance.getTopic(Queues.ENDED_JOB_TOPIC);
		topic.publish(job);
		return true;
	}
}