/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.server.servlet;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.pepstock.jem.console.commands.resources.Get;
import org.pepstock.jem.console.commands.resources.GetList;
import org.pepstock.jem.console.commands.resources.Remove;
import org.pepstock.jem.console.commands.resources.Set;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.CommonResourcesManager;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.Resources;
import org.pepstock.jem.node.resources.ResourcesUtil;

import com.thoughtworks.xstream.XStream;

/**
 * Manages all the actions on common resources. Receives action by parameters list and uses the content to receive and return 
 * entities to client.
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class CommonResources extends JemDefaultServlet {

	private static final long serialVersionUID = 1L;

	
	private transient CommonResourcesManager manager = null; 

	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.server.servlet.DefaultServlet#execute(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	public void execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		super.execute(request, response);
		
		// if common resources manager is null, creates an instance 
		if (manager == null){
			manager = new CommonResourcesManager();
		}
		
		Object returnedObject = null;
		XStream streamer = new XStream();
		// gets action. The actions are the names of command classes
		String action = request.getParameter(ResourcesUtil.ACTION_PARM);
		try {
			// checks which action has been received
			// SET action
			if (action.equalsIgnoreCase(Set.class.getName())){
				// gets the resource from content, deserializing it
				Object object = streamer.fromXML(request.getReader());
				// checks if is resource
				if (object instanceof Resource){
					// cast and puts resource
					Resource resource = (Resource)object;
					boolean isAdded = manager.put(resource);
					returnedObject = Boolean.valueOf(isAdded);
				} else if (object instanceof Resources){
					Resources resources = (Resources)object;
					boolean isAdded = true;
					for (Resource resource : resources.getResources()){
						boolean added = manager.put(resource);
						isAdded = isAdded && added;
					}
					returnedObject = Boolean.valueOf(isAdded);
				} else {
					throw new ServletException(UserInterfaceMessage.JEMG028E.toMessage().getFormattedMessage("set", object.getClass().getName()));
				}
			} else if (action.equalsIgnoreCase(Get.class.getName())){
				// GET action
				// gets the resource name from content, deserializing it
				Object object = streamer.fromXML(request.getReader());
				if (object instanceof String){
					String name = object.toString();
					// gets the resource definition
					Resource resource = manager.get(name);
					returnedObject = resource;
				} else {
					throw new ServletException(UserInterfaceMessage.JEMG028E.toMessage().getFormattedMessage("get", object.getClass().getName()));
				}
			} else if (action.equalsIgnoreCase(Remove.class.getName())){
				// REMOVE action
				// gets the resource name from content, deserializing it
				Object object = streamer.fromXML(request.getReader());
				if (object instanceof String){
					String name = object.toString();
					// removes the resource definition, if exists
					boolean isRemoved = manager.remove(name);
					returnedObject = Boolean.valueOf(isRemoved);
				} else {
					throw new ServletException(UserInterfaceMessage.JEMG028E.toMessage().getFormattedMessage("remove", object.getClass().getName()));
				}
			} else if (action.equalsIgnoreCase(GetList.class.getName())){
				// GET LIST action
				// gets the resource name from content, deserializing it
				Object object = streamer.fromXML(request.getReader());
				if (object instanceof String){
					String name = object.toString();

					// scans all resources creating a buffer to send back.
					//				Collection<Resource> resourcesCollection = manager.values();
					ArrayList<Resource> resourcesCollection = new ArrayList<Resource>(manager.values(name));
					//StringBuffer buffer = new StringBuffer();
					Resources resources = new Resources();
					resources.setResources(resourcesCollection);
					//				for (Resource resource: resourcesCollection){
					//					buffer.append(resource.toString()).append('\n');
					//				}
					//				returnedObject = buffer.toString();
					returnedObject = resources;
				} else {
					throw new ServletException(UserInterfaceMessage.JEMG028E.toMessage().getFormattedMessage("get", object.getClass().getName()));
				}

			}
			// return the objects in the content
			// using XStream and then in XML format
			response.setContentType("text/xml");
			response.getWriter().print(streamer.toXML(returnedObject));
			response.getWriter().close();
		} catch (Exception ex){
			throw new ServletException(ex);
		}
	}

}