/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013  Marco "Fuzzo" Cuccato
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.server.rest.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.pepstock.jem.OutputListItem;

import com.thoughtworks.xstream.XStream;

/**
 * Adapter for a Map object. Map object is not supported by REST for this reason an adapter is needed
 * 
 * @author Marco "Fuzzo" Cuccato
 *
 */
public final class OutputListItemMapAdapter extends XmlAdapter<MapType, Map<String, ArrayList<OutputListItem>>> {

	private XStream stream = new XStream();

	/* (non-Javadoc)
	 * @see javax.xml.bind.annotation.adapters.XmlAdapter#marshal(java.lang.Object)
	 */
	@Override
	public MapType marshal(Map<String, ArrayList<OutputListItem>> arg0) throws Exception {
		// to serialize, uses XStream
		MapType myMapType = new MapType();
		for (Entry<String, ArrayList<OutputListItem>> entry : arg0.entrySet()) {
			MapEntryType myMapEntryType = new MapEntryType();
			myMapEntryType.key = entry.getKey();
			String value = stream.toXML(entry.getValue());
			myMapEntryType.value = value;
			myMapType.entry.add(myMapEntryType);
		}
		return myMapType;
	}

	/* (non-Javadoc)
	 * @see javax.xml.bind.annotation.adapters.XmlAdapter#unmarshal(java.lang.Object)
	 */
	@Override
	@SuppressWarnings("unchecked")
	public Map<String, ArrayList<OutputListItem>> unmarshal(MapType arg0) throws Exception {
		// to deserialize, uses XStream
		HashMap<String, ArrayList<OutputListItem>> hashMap = new HashMap<String, ArrayList<OutputListItem>>();
		for (MapEntryType myEntryType : arg0.entry) {
			ArrayList<OutputListItem> list = (ArrayList<OutputListItem>)stream.fromXML(myEntryType.value);
			hashMap.put(myEntryType.key, list);
		}
		return hashMap;
	}

}