/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.server.listeners;

import java.util.Set;

import org.pepstock.jem.gwt.server.commons.NodeInfoUtility;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.node.NodeInfo;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;

/**
 * Listener of cluster membership to understand if the JEM group is available or not.<br>
 * If is coming available, stores itself in node map.
 * 
 * @author Andrea "Stock" Stocchero
 *
 */
public class NodeListener implements MembershipListener {

	/**
	 * Checks if JEM group is available, after adding a new member
	 */
	@Override
	public void memberAdded(MembershipEvent event) {
		Member member = event.getMember();
		// if group is already available, do nothing
		if (!SharedObjects.getInstance().isDataClusterAvailable()){
			// if is lite, do nothing because it doesn't change anything
			if (!member.isLiteMember()){
				// we have a new memeber of cluster!!!
				// set AVAILABLE
				SharedObjects.getInstance().setDataClusterAvailable(true);
				// Stores node info
				NodeInfo info = SharedObjects.getInstance().getInfo();
				NodeInfoUtility.checkAndStoreNodeInfo(info);
			}
		}
	}

	/**
	 * Checks if JEM group is still available, after removing a member
	 */
	@Override
	public void memberRemoved(MembershipEvent event) {
		// gets removed member
		Member memberRemoved = event.getMember();
		// if removed member is lite, do nothing 
		if (memberRemoved.isLiteMember())
			return;
		
		// scans all member to look if an active member is running
		Cluster cluster = SharedObjects.getInstance().getLocalMember().getCluster();
		Set<Member> setMembers  = cluster.getMembers();
		for (Member member : setMembers) {
			if (!member.isLiteMember()){
				// there is at least a member so JEM group member is available 
				SharedObjects.getInstance().setDataClusterAvailable(true);
				return;
			}
		}
		// scan is finished so no member is available!!
		SharedObjects.getInstance().setDataClusterAvailable(false);
	}
}