/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013  Marco "Fuzzo" Cuccato
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.services;

import java.util.Map;

import org.pepstock.jem.gwt.client.security.LoggedUser;
import org.pepstock.jem.node.security.UserPreference;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * The client side stub for the RPC service. Provides all login actions
 */
@RemoteServiceRelativePath(Services.LOGIN)
public interface LoginManagerService extends RemoteService {

	/**
	 * Called when client application starts to have the already logged user of
	 * null (if not authenticated)
	 * 
	 * @return already logged user or <code>null</code>
	 * @throws Exception
	 *             if JEM group is not available
	 */
	LoggedUser getUser() throws Exception;

	/**
	 * Logs in using userid and password. Returns logged user.
	 * 
	 * @param userid
	 *            userid of user
	 * @param password
	 *            password
	 * @return logged user
	 * @throws Exception
	 *             if authentication error occurs
	 */
	LoggedUser login(String userid, String password) throws Exception;

	/**
	 * Logs out the user
	 * 
	 * @param preferences to store 
	 * @return always true
	 * @throws Exception
	 *             if authentication error occurs
	 */
	Boolean logoff(Map<String, UserPreference> preferences) throws Exception;
	
	/**
	 * Stores user preferences
	 * 
	 * @param preferences preferences to store
	 * @return always true
	 * @throws Exception if any error occurs
	 */
	Boolean storePreferences(Map<String, UserPreference> preferences) throws Exception;

}