/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.services;

import org.pepstock.jem.node.About;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * @author Andrea "Stock" Stocchero
 *
 */
@RemoteServiceRelativePath(Services.INFO)
public interface InfoService extends RemoteService {

	/**
	 * Length of array of data to return
	 */
	public static final int INFO_SIZE = 5;

	/**
	 * Index of array for JEM group
	 */
	public static final int NAME = 0;

	/**
	 * Index of array for count of nodes
	 */
	public static final int NODES_COUNT = 1;

	/**
	 * Index of array for job in execution
	 */
	public static final int EXECUTION_JOB_COUNT = 2;

	/**
	 * Index of array for JEM group started time
	 */
	public static final int STARTED_TIME = 3;
	
	/**
	 * Index of array for JEM group time
	 */
	public static final int CURRENT_TIME = 4;
	
	/**
	 * Length of array of data to return
	 */
	public static final int INFO_LOGO_SIZE = 2;

	/**
	 * Index of array for JEM group
	 */
	public static final int URL = 0;

	/**
	 * Index of array for count of nodes
	 */
	public static final int LINK = 1;

	
	/**
	 * @return
	 * @throws Exception
	 */
	String[] getEnvironmentInformation() throws Exception;
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	String[] getLogoURL() throws Exception;
	
	/**
	 * Returns the information about build time, version and licenses
	 * @return about instance with all info inside
	 * @throws Exception if any exception occurs
	 */
	About getAbout() throws Exception;

}