package org.pepstock.jem.gwt.client.services;

import java.util.Collection;

import org.pepstock.jem.node.resources.custom.ResourceDescriptor;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * The client side stub for the RPC service. Provides all actions for custom common resources management 
 * @author Marco "Fuzzo" Cuccato
 */
@RemoteServiceRelativePath(Services.CUSTOM_RESOURCE_DEFINITIONS)
public interface CustomResourceDefinitionsManagerService extends RemoteService {
	
	/**
	 * Returns all custom resource names
	 * @return a collection containing all custom resource names
	 * @throws Exception if error occours
	 */
	Collection<String> getAllResourceNames() throws Exception;
	
	/**
	 * Returns all custom {@link ResourceDescriptor}s
	 * @return a collection containing all {@link ResourceDescriptor}
	 * @throws Exception if error occours
	 */
	Collection<ResourceDescriptor> getAllResourceDescriptors() throws Exception;
	
	/**
	 * Get the descriptor specified by name
	 * @param resourceName the name of {@link ResourceDescriptor} 
	 * @return the {@link ResourceDescriptor} identified by <code>resourceName</code>
	 * @throws Exception if error occours
	 */
	ResourceDescriptor getDescriptorOf(String resourceName) throws Exception;
}
