/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.security;

import java.util.LinkedList;

import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.security.UserPreference;
import org.pepstock.jem.util.TimeUtils;

import com.google.gwt.user.client.Timer;

/**
 * Contains the logged user.
 * 
 * @author Andrea "Stock" Stocchero
 *
 */
public class CurrentUser {
	
	private static final CurrentUser CURRENT_USER =  new CurrentUser();
	
	/**
	 * The interval between header information refresh
	 */
	protected static final int PREFERENCES_STORE_INTERVAL = (int) (30 * TimeUtils.SECOND);
	
	private long previousUpdateTime = 0L;
	
	private long lastUpdateTime = 0L;
	
	private CurrentUser(){
		Timer preferencesStoreTimer = new Timer() {

			@Override
			public void run() {
				if (user != null){
					storePreferences();
				}
			}
		}; 
		preferencesStoreTimer.run();
		preferencesStoreTimer.scheduleRepeating(PREFERENCES_STORE_INTERVAL);
	}
	
	/**
	 * Stores the user preferences
	 */
	public void storePreferences(){
		if (previousUpdateTime != lastUpdateTime){
			Services.LOGIN_MANAGER.storePreferences(CurrentUser.getInstance().getUser().getPreferences(), new ServiceAsyncCallback<Boolean>() {

				@Override
				public void onJemFailure(Throwable caught) {
					caught.printStackTrace();
				}

				@Override
				public void onJemSuccess(Boolean result) {
					previousUpdateTime = lastUpdateTime;
				}

				@Override
                public void onJemExecuted() {
                }
			});
		}
	}
	
	/**
	 * @return
	 */
	public static final CurrentUser getInstance(){
		return CURRENT_USER;
	}
	
	/**
	 * Logged User instance! used to check permissions 
	 */
	private LoggedUser user = null;

	/**
	 * @return the uSER
	 */
	public LoggedUser getUser() {
		return user;
	}

	/**
	 * @param user the uSER to set
	 */
	public void setUser(LoggedUser user) {
		this.user = user;
	}

	public String getStringPreference(String key){
		if (key != null){
			UserPreference pref = CurrentUser.getInstance().getUser().getPreferences().get(key);
			if (pref != null){
				if (pref.isValueString()){
					return pref.getValueString();
				}
			}
		}
		return null;
	}
	
	public LinkedList<String> getListPreference(String key){
		if (key != null){
			UserPreference pref = CurrentUser.getInstance().getUser().getPreferences().get(key);
			if (pref != null){
				if (!pref.isValueString()){
					return pref.getValueList();
				}
			}
		}
		return null;
	}
	
	public void setStringPreference(String key, String value){
		if (key != null){
			UserPreference pref = CurrentUser.getInstance().getUser().getPreferences().get(key);
			if (pref == null){
				pref = new UserPreference();
			}
			pref.setValueString(value);
			getUser().getPreferences().put(key, pref);
			setLastUpdateTime();
		}
	}
	
	public void setListPreference(String key, LinkedList<String> value){
		if (key != null){
			UserPreference pref = new UserPreference();
			pref.setValueList(value);
			getUser().getPreferences().put(key, pref);
			setLastUpdateTime();
		}
	}
	
	/**
	 * @return the lastUpdateTime
	 */
	public long getLastUpdateTime() {
		return lastUpdateTime;
	}

	/**
	 * the lastUpdateTime to set
	 */
	public void setLastUpdateTime() {
		this.lastUpdateTime = System.currentTimeMillis();
	}

}