/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.rest;

import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;

import org.pepstock.jem.OutputFileContent;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.gwt.server.rest.JobsManagerImpl;
import org.pepstock.jem.gwt.server.rest.entities.JobId;
import org.pepstock.jem.gwt.server.rest.entities.JobOutputFileContent;
import org.pepstock.jem.gwt.server.rest.entities.JobOutputListArgument;
import org.pepstock.jem.gwt.server.rest.entities.JobOutputTreeContent;
import org.pepstock.jem.gwt.server.rest.entities.Jobs;
import org.pepstock.jem.gwt.server.rest.entities.ReturnedObject;
import org.pepstock.jem.util.RestClient;

import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;

/**
 * @author Andrea "Stock" Stocchero
 *
 */
public class JobsManager {

	/**
	 * 
	 */
	public JobsManager() {
	}

	/**
	 * 
	 * @param jobNameFilter
	 * @return
	 * @throws Exception
	 */
	public Jobs getInputQueue(String jobNameFilter) throws Exception {
		return getJobs(JobsManagerImpl.JOBS_MANAGER_INPUT_PATH, jobNameFilter);
	}

	/**
	 * 
	 * @param jobNameFilter
	 * @return
	 * @throws Exception
	 */
	public Jobs getRunningQueue(String jobNameFilter) throws Exception {
		return getJobs(JobsManagerImpl.JOBS_MANAGER_RUNNING_PATH, jobNameFilter);
	}

	/**
	 * 
	 * @param jobNameFilter
	 * @return
	 * @throws Exception
	 */
	public Jobs getOutputQueue(String jobNameFilter) throws Exception {
		return getJobs(JobsManagerImpl.JOBS_MANAGER_OUTPUT_PATH, jobNameFilter);
	}

	/**
	 * 
	 * @param jobNameFilter
	 * @return
	 * @throws Exception
	 */
	public Jobs getRoutingQueue(String jobNameFilter) throws Exception {
		return getJobs(JobsManagerImpl.JOBS_MANAGER_ROUTING_PATH, jobNameFilter);
	}

	/**
	 * 
	 * @param jobs
	 * @throws Exception
	 */
	public void hold(Jobs jobs) throws Exception {
		doAction(JobsManagerImpl.JOBS_MANAGER_HOLD_PATH, jobs);
	}

	/**
	 * 
	 * @param jobs
	 * @throws Exception
	 */
	public void release(Jobs jobs) throws Exception {
		doAction(JobsManagerImpl.JOBS_MANAGER_RELEASE_PATH, jobs);
	}

	/**
	 * 
	 * @param preJob
	 * @return
	 * @throws Exception 
	 */
	public String submit(PreJob preJob) throws Exception {
		WebResource resource = RestClient.getInstance().getBaseWebResource();
		GenericType<JAXBElement<JobId>> generic = new GenericType<JAXBElement<JobId>>() {};
	    try {
	    	JAXBElement<JobId> jaxbContact = resource.path(JobsManagerImpl.JOBS_MANAGER_PATH).path(JobsManagerImpl.JOBS_MANAGER_SUBMIT_PATH).accept(MediaType.APPLICATION_XML).post(generic, preJob);
	    	JobId object = jaxbContact.getValue();
			if (object.hasException()){
				throw new Exception(object.getExceptionMessage());
			}
			return object.getId();
	    } catch (UniformInterfaceException e){
	    	if (e.getResponse().getStatus() != 204){
	    		throw e;
	    	}
	    	return null;
	    }
		
//		WebResource resource = RestClient.getInstance().getBaseWebResource();
//    	return resource.path(JobsManagerImpl.JOBS_MANAGER_PATH).path(JobsManagerImpl.JOBS_MANAGER_SUBMIT_PATH).accept(MediaType.APPLICATION_XML).post(String.class, preJob);
	}
	
	
	/**
	 * @param jobs
	 * @return
	 * @throws Exception
	 */
	public JobOutputTreeContent getOutputTree(Jobs jobs) throws Exception {
		WebResource resource = RestClient.getInstance().getBaseWebResource();
	    GenericType<JAXBElement<JobOutputTreeContent>> generic = new GenericType<JAXBElement<JobOutputTreeContent>>() {};
	    try {
	    	JAXBElement<JobOutputTreeContent> jaxbContact = resource.path(JobsManagerImpl.JOBS_MANAGER_PATH).path(JobsManagerImpl.JOBS_MANAGER_OUTPUT_TREE_PATH).accept(MediaType.APPLICATION_XML).post(generic, jobs);
	    	JobOutputTreeContent object = jaxbContact.getValue();
			if (object.hasException()){
				throw new Exception(object.getExceptionMessage());
			}
		
			return object;    	
	    } catch (UniformInterfaceException e){
	    	if (e.getResponse().getStatus() != 204){
	    		throw e;
	    	}
	    	return null;
	    }
	}
	
	/**
	 * @param jobFileContent
	 * @return
	 * @throws Exception
	 */
	public OutputFileContent getOutputFileContent(JobOutputListArgument jobFileContent) throws Exception {
		WebResource resource = RestClient.getInstance().getBaseWebResource();
	    GenericType<JAXBElement<JobOutputFileContent>> generic = new GenericType<JAXBElement<JobOutputFileContent>>() {};
	    try {
	    	JAXBElement<JobOutputFileContent> jaxbContact = resource.path(JobsManagerImpl.JOBS_MANAGER_PATH).path(JobsManagerImpl.JOBS_MANAGER_OUTPUT_FILE_CONTENT_PATH).accept(MediaType.APPLICATION_XML).post(generic, jobFileContent);
	    	JobOutputFileContent object = jaxbContact.getValue();
			if (object.hasException()){
				throw new Exception(object.getExceptionMessage());
			}
			return object.getOutputFileContent();
	    } catch (UniformInterfaceException e){
	    	if (e.getResponse().getStatus() != 204){
	    		throw e;
	    	}
	    	return null;
	    }
	}
	/**
	 * 
	 * @param method
	 * @param filter
	 * @return
	 * @throws Exception
	 */
	private Jobs getJobs(String method, String filter) throws Exception{
		WebResource resource = RestClient.getInstance().getBaseWebResource();
		GenericType<JAXBElement<Jobs>> generic = new GenericType<JAXBElement<Jobs>>() {};
	    try {
	    	JAXBElement<Jobs> jaxbContact = resource.path(JobsManagerImpl.JOBS_MANAGER_PATH).path(method).accept(MediaType.APPLICATION_XML).post(generic, filter);
	    	Jobs object = jaxbContact.getValue();
			if (object.hasException()){
				throw new Exception(object.getExceptionMessage());
			}
			return object;
	    } catch (UniformInterfaceException e){
	    	if (e.getResponse().getStatus() != 204){
	    		throw e;
	    	}
	    	return null;
	    }
	}
	
	/**
	 * 
	 * @param method
	 * @param jobs
	 * @throws Exception
	 */
	private void doAction(String method, Jobs jobs) throws Exception{
		WebResource resource = RestClient.getInstance().getBaseWebResource();
		GenericType<JAXBElement<ReturnedObject>> generic = new GenericType<JAXBElement<ReturnedObject>>() {};
	    try {
	    	JAXBElement<ReturnedObject> jaxbContact = resource.path(JobsManagerImpl.JOBS_MANAGER_PATH).path(method).accept(MediaType.APPLICATION_XML).post(generic, jobs);
	    	ReturnedObject object = jaxbContact.getValue();
			if (object.hasException()){
				throw new Exception(object.getExceptionMessage());
			}
	    } catch (UniformInterfaceException e){
	    	if (e.getResponse().getStatus() != 204){
	    		throw e;
	    	}
	    }
	}
}