/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.rest;

import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;

import org.pepstock.jem.GfsFile;
import org.pepstock.jem.gwt.server.rest.GfsManagerImpl;
import org.pepstock.jem.gwt.server.rest.entities.GfsFileList;
import org.pepstock.jem.gwt.server.rest.entities.GfsOutputContent;
import org.pepstock.jem.util.RestClient;

import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;

/**
 * @author Enrico Frigo
 *
 */
public class GfsManager {

	/**
	 * 
	 */
	public GfsManager() {
	}


    public String getFileData(String path) throws Exception {
    	return getFile(GfsManagerImpl.GFS_MANAGER_FILE_DATA+"", path);
    }
    public String getFileLibrary(String path) throws Exception {
    	return getFile(GfsManagerImpl.GFS_MANAGER_FILE_LIBRARY+"", path);
    }
    public String getFileClass(String path) throws Exception {
    	return getFile(GfsManagerImpl.GFS_MANAGER_FILE_CLASS+"", path);
    }
    public String getFileSource(String path) throws Exception {
    	return getFile(GfsManagerImpl.GFS_MANAGER_FILE_SOURCE+"", path);
    }
    public String getFileBinary(String path) throws Exception {
    	return getFile(GfsManagerImpl.GFS_MANAGER_FILE_BINARY+"", path);
    }
	
	/**
	 * 
	 * @param type
	 * @param file
	 * @return
	 * @throws Exception
	 */
    public String getFile(String type, String file) throws Exception {
    	WebResource resource = RestClient.getInstance().getBaseWebResource();
	    GenericType<JAXBElement<GfsOutputContent>> generic = new GenericType<JAXBElement<GfsOutputContent>>() {};
	    try {
	    	JAXBElement<GfsOutputContent> jaxbContact = resource.path(GfsManagerImpl.GFS_MANAGER_PATH)
	    	.path(GfsManagerImpl.GFS_MANAGER_OUTPUT_FILE_CONTENT_PATH)
	    	.path(type)
	    	.accept(MediaType.APPLICATION_XML).post(generic, file);
	    	GfsOutputContent object = jaxbContact.getValue();
			if (object.hasException()){
				throw new Exception(object.getExceptionMessage());
			}
			return object.getContent();
	    } catch (UniformInterfaceException e){
	    	if (e.getResponse().getStatus() != 204){
	    		throw e;
	    	}
	    	return null;
	    }
	}

    public GfsFileList getFilesListData(String path) throws Exception {
    	return getFilesList(GfsManagerImpl.GFS_MANAGER_FILE_DATA+"", path);
    }

    public GfsFileList getFilesListLibrary(String path) throws Exception {
    	return getFilesList(GfsManagerImpl.GFS_MANAGER_FILE_LIBRARY+"", path);
    }
    public GfsFileList getFilesListClass(String path) throws Exception {
    	return getFilesList(GfsManagerImpl.GFS_MANAGER_FILE_CLASS+"", path);
    }
    public GfsFileList getFilesListSource(String path) throws Exception {
    	return getFilesList(GfsManagerImpl.GFS_MANAGER_FILE_SOURCE+"", path);
    }
    public GfsFileList getFilesListBinary(String path) throws Exception {
    	return getFilesList(GfsManagerImpl.GFS_MANAGER_FILE_BINARY+"", path);
    }
    /**
     * 
     * @param type
     * @param path
     * @return
     * @throws Exception
     */
    private GfsFileList getFilesList(String type, String path) throws Exception {
		WebResource resource = RestClient.getInstance().getBaseWebResource();
		GenericType<JAXBElement<GfsFileList>> generic = new GenericType<JAXBElement<GfsFileList>>() {};
	    try {
	    	JAXBElement<GfsFileList> jaxbContact = resource.path(GfsManagerImpl.GFS_MANAGER_PATH)
	    	.path(GfsManagerImpl.GFS_MANAGER_FILE_LIST)
	    	.path(type)
	    	.accept(MediaType.APPLICATION_XML).post(generic, path);
	    	GfsFileList object = jaxbContact.getValue();
			if (object.hasException()){
				throw new Exception(object.getExceptionMessage());
			}
			return object;
	    } catch (UniformInterfaceException e){
	    	if (e.getResponse().getStatus() != 204){
	    		throw e;
	    	}
	    	return null;
	    }
	}
	
}