/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Marco "Fuzzo" Cuccato
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.swarm.commons;

import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.AbstractTabPanelInspector;
import org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.node.General;
import org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.node.NodeHeader;
import org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.node.System;

import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TabPanel;

/**
 * Component which shows all node information. Can be called to see a node.
 * 
 * @author Marco "Fuzzo" Cuccato
 * @version 1.0	
 *
 */
public class NodeInfoInspector extends AbstractTabPanelInspector {

	private TabPanel main = new TabPanel();
	
	private NodeInfoBean node = null;
	
	/**
	 * Construct the UI<br>
	 * 
	 * @param node
	 */
	public NodeInfoInspector(NodeInfoBean node){
		setNode(node);

		main.add(new General(node), "General");
		main.add(new System(node), "System");
		// selects general
		main.selectTab(0);
	}

	/**
	 * @return The {@link NodeInfoBean} instance
	 */
	public NodeInfoBean getNode() {
		return node;
	}
	
	/**
	 * @param node Set the {@link NodeInfoBean} instance
	 */
	public void setNode(NodeInfoBean node) {
		this.node = node;
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.commons.AbstractTabPanelInspector#getTabPanel()
	 */
    @Override
    public TabPanel getTabPanel() {
	    return main;
    }

	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.commons.NewAbstractInspector#getHeader()
	 */
    @Override
    public FlexTable getHeader() {
	    return new NodeHeader(node.getLabel(), this);
    }

	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.commons.NewAbstractInspector#getActions()
	 */
    @Override
    public Panel getActions() {
	    return null;
    }
}