/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.roles;

import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AbstractTabPanelInspector;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.roles.inspector.Actions;
import org.pepstock.jem.gwt.client.panels.roles.inspector.AdvancedPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.DatasourcePermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.FilePermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.NewRoleHeader;
import org.pepstock.jem.gwt.client.panels.roles.inspector.PermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.RoleHeader;
import org.pepstock.jem.gwt.client.panels.roles.inspector.SearchPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.SurrogatePermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.UsersPanel;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.log.Message;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.TabPanel;

/**
 * Componet which allows to update a role or insert a new one. 
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class RoleInspector extends AbstractTabPanelInspector {
	
	private final Loading loading = new Loading();
	
	/**
	 * 
	 */
	public static final int NEW = 0;
	
	/**
	 * 
	 */
	public static final int UPDATE = 1;
	
	/**
	 * 
	 */
	public static final int CLONE = 2;
	
	private int action = NEW;
	
	private Role role = null;
	
	private TabPanel mainPanel = new TabPanel();
	
	private Actions actions = null;
	
	
	/**
	 * Constructs a new component to add a new role
	 */
	public RoleInspector(){
		this(new Role(), NEW);
		getRole().setRemovable(true);
	}
	/**
	 * Constructs a new component to update the role, passed as argument
	 * 
	 * @param role role to update
	 */
	public RoleInspector(Role role){
		this(role, UPDATE);
	}

	/**
	 * Constructs privately a new component to manage the role
	 * 
	 * @param role role to manage
	 * @param action 
	 */
	public RoleInspector(Role role, int action) {
		super(true);
		// saves arguments
		setRole(role);
		setAction(action);
		
		if (role.isRemovable()){
			mainPanel.add(new PermissionsPanel(role), "Views and Actions");
		}
		// checks is not admin
		if (!role.getPermissions().contains(Permissions.STAR)){
			mainPanel.add(new SearchPermissionsPanel(role), "Searches");
			mainPanel.add(new DatasourcePermissionsPanel(role), "Datasources");
			mainPanel.add(new FilePermissionsPanel(role), "Files");
			mainPanel.add(new SurrogatePermissionsPanel(role), "Surrogate");
			mainPanel.add(new AdvancedPermissionsPanel(role), "Advanced");
		}
		
		UsersPanel usersPanel = new UsersPanel(role);
		mainPanel.add(usersPanel, "Users");
		
		mainPanel.setWidth(Sizes.HUNDRED_PERCENT);
		
//		int heightWidget = getAvailableHeight() - 
//				Sizes.TABBAR_HEIGHT_PX - 
//				Sizes.MAIN_TAB_PANEL_PADDING_TOP_LEFT_RIGHT - 
//				Sizes.MAIN_TAB_PANEL_PADDING_BOTTOM - 
//				Sizes.MAIN_TAB_PANEL_BORDER;
//		int widthWidget = getWidth() - 
//				Sizes.MAIN_TAB_PANEL_PADDING_TOP_LEFT_RIGHT - 
//				Sizes.MAIN_TAB_PANEL_PADDING_TOP_LEFT_RIGHT - 
//				Sizes.MAIN_TAB_PANEL_BORDER  - 
//				Sizes.MAIN_TAB_PANEL_BORDER;
//		
//		for (int i=0; i<mainPanel.getWidgetCount(); i++){
//			Widget w = mainPanel.getWidget(i);
//			if (w instanceof ResizeCapable){
//				ResizeCapable rc = (ResizeCapable)w;
//				//rc.onResize(widthWidget, heightWidget);
//				rc.onResize(getAvailableWidth(), getAvailableHeight());
//			}
//		}
		
		actions = new Actions(role);
		actions.setInspector(this);

		mainPanel.selectTab(0);
	}

	/**
	 * @return the role
	 */
	public Role getRole() {
		return role;
	}

	/**
	 * @param role the role to set
	 */
	public void setRole(Role role) {
		this.role = role;
	}

	/**
	 * @return the action
	 */
	public int getAction() {
		return action;
	}
	
	/**
	 * @param action the action to set
	 */
	public void setAction(int action) {
		this.action = action;
	}
	
	/**
	 * Cancel if pressed, so hide the popup
	 */
	public void cancel() {
		hide();
	}
	
	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.commons.NewAbstractInspector#getHeader()
	 */
    @Override
    public FlexTable getHeader() {
		// if is for a new role, create a different header (with text field)
		if (getAction() == UPDATE) {
			return new RoleHeader(getRole().getName(), this);
		} else {
			return new NewRoleHeader(getRole(), this);
		}
    }
	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.commons.NewAbstractInspector#getCenter()
	 */
    @Override
    public TabPanel getTabPanel() {
	    return mainPanel;
    }
	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.commons.NewAbstractInspector#getActions()
	 */
    @Override
    public CellPanel getActions() {
	    return actions;
    }

	/**
	 * save the updated or new role
	 */
	public void save() {
		if (role.getName() != null) {
			if (!role.getName().trim().isEmpty()) {
				
				loading.startProcessing();
				
			    Scheduler scheduler = Scheduler.get();
			    scheduler.scheduleDeferred(new ScheduledCommand() {
					
					@Override
					public void execute() {
						// checks if the name is valid for new role
						if (getAction() != UPDATE) {
							Services.ROLES_MANAGER.addRole(role, new ServiceAsyncCallback<Boolean>() {

								@Override
								public void onJemSuccess(Boolean result) {
								}

								@Override
								public void onJemFailure(Throwable caught) {
									AlertMessageBox alert = new AlertMessageBox(Message.ERROR, "Add role command error!", 
											caught.getMessage());
									alert.open();
								}

								@Override
                                public void onJemExecuted() {
									loading.stopProcessing();
									// hide the popup
									hide();
                                }
							});

						} else {
							Services.ROLES_MANAGER.updateRole(role, new ServiceAsyncCallback<Boolean>() {
								@Override
								public void onJemSuccess(Boolean result) {
								}

								@Override
								public void onJemFailure(Throwable caught) {
									AlertMessageBox alert = new AlertMessageBox(Message.ERROR, "Update role command error!", 
											caught.getMessage());
									alert.open();
								}
								
								@Override
                                public void onJemExecuted() {
									loading.stopProcessing();
									// hide the popup
									hide();
                                }
							});
						}

					}
			    });

			} else {
				AlertMessageBox alert = new AlertMessageBox(Message.ERROR, "Role name empty!", 
						"Role name is empty. Please type a Role name");
				alert.open();
			}
		} else {
			AlertMessageBox alert = new AlertMessageBox(Message.ERROR, "Invalid role name!", 
					"Please type a valid Role name");
			alert.open();
		}
	}

}