package org.pepstock.jem.gwt.client.panels.resources;

import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.Toast;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourceHeader;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourcesPropertiesPanel;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.log.Message;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.custom.ResourceDescriptor;

import com.google.gwt.user.client.ui.FlexTable;

/**
 * An inspector that let the user to view, modify and save an existing {@link Resource}
 * @author Marco "Fuzzo" Cuccato
 *
 */
public class ExistingResourceInspector extends AbstractResourceInspector {

	/**
	 * Builds a {@link ExistingResourceInspector}
	 * @param resource the underlying {@link Resource}
	 */
	public ExistingResourceInspector(Resource resource) {
		super(resource);
		buildExistingPanel();
	}

	private void buildExistingPanel() {
		// obtain the ootb specific panel, if the resource is a custom type, it will be null 
		Class<? extends ResourcesPropertiesPanel> panelClass = RESOURCES_TYPES.get(getResource().getType().toUpperCase());
		if (panelClass != null) {
			// it's a ootb resource 
			try {
				ResourcesPropertiesPanel ootbPanel = renderOOTBResourcePanel(getResource().getType().toUpperCase());
				showResourcePanel(ootbPanel);
			} catch (Exception e) {
				Toast t = new Toast(Message.ERROR, "Cannot render custom resource panel!", "Rendering error");
				t.show();
			}
		} else {
			// it's a custom resource, need to load the descriptor and render the corrisponding panel
			Services.CUSTOM_RESOURCE_DEFINITIONS_MANAGER.getDescriptorOf(getResource().getType(), new ServiceAsyncCallback<ResourceDescriptor>() {
				@Override
				public void onJemFailure(Throwable caught) {
					AlertMessageBox errorBox = new AlertMessageBox(Message.ERROR, "Custom Resource Definitions Error!", "Unable to load cutom resource definition: " + caught.getMessage());
					errorBox.open();
				}

				@Override
				public void onJemSuccess(ResourceDescriptor descriptor) {
					ResourcesPropertiesPanel customResourcePanel = renderCustomResourcePanel(descriptor); 
					if (customResourcePanel == null) {
						AlertMessageBox box = new AlertMessageBox(Message.ERROR, "Oops!", "I have no panel that fit resource with type: '" + getResource().getType() + "', sorry!");
						box.open();
					} else {
						customResourcePanel.loadProperties();
						showResourcePanel(customResourcePanel);
					}
				}
				
				@Override
                public void onJemExecuted() {
                }
			});
		}
	}

	public void showResourcePanel(ResourcesPropertiesPanel activePanel) {
		int newAvailableWidth = getAvailableWidth();
		int newAvailableHeight = getAvailableHeight();
		mainContainer.add(resourcePanelContainer);
		resourcePanelContainer.setWidget(activePanel);
		resourcePanelContainer.setSize(Sizes.toString(newAvailableWidth), Sizes.toString(newAvailableHeight));
		activePanel.onResize(newAvailableWidth, newAvailableHeight);
	}

	@Override
	public void save() {
		if (checkMandatoryAttributes() && validate()) {
			Services.COMMON_RESOURCES_MANAGER.updateCommonResource(getResource(), new ServiceAsyncCallback<Boolean>() {
	
				@Override
				public void onJemSuccess(Boolean result) {
				}
	
				@Override
				public void onJemFailure(Throwable caught) {
					AlertMessageBox alert = new AlertMessageBox(Message.ERROR, "Update resource command error!", caught.getMessage());
					alert.open();
				}
				
				@Override
                public void onJemExecuted() {
					hide(); // hide the popup
                }
			});
		}
	}

	@Override
	public FlexTable getHeader() {
		return new ResourceHeader("[" + getResource().getType() + "] " + getResource().getName(), this);
	}
	
}
