package org.pepstock.jem.gwt.client.panels.resources;

import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.resources.inspector.NewResourceHeader;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.log.Message;
import org.pepstock.jem.node.resources.Resource;

import com.google.gwt.user.client.ui.FlexTable;

/**
 * An inspector that let the user to view, modify and save a new {@link Resource}, with same properties of an existing one 
 * @author Marco "Fuzzo" Cuccato
 *
 */
public class CloneResourceInspector extends ExistingResourceInspector {

	/**
	 * Builds a {@link CloneResourceInspector}
	 * @param resource the cloned resource
	 */
	public CloneResourceInspector(Resource resource) {
		super(resource);
		// clean resource name to let user choose a new one
		getResource().setName(null);
	}

	@Override
	public void save() {
		if (checkMandatoryAttributes()) {
			// checks if the name is valid for new resource
			if (getResource().getName() != null && !getResource().getName().trim().isEmpty()) {
				Services.COMMON_RESOURCES_MANAGER.addCommonResource(getResource(), new ServiceAsyncCallback<Boolean>() {
					@Override
					public void onJemSuccess(Boolean result) {
					}
	
					@Override
					public void onJemFailure(Throwable caught) {
						AlertMessageBox alert = new AlertMessageBox(Message.ERROR, "Add resource command error!", caught .getMessage());
						alert.open();
					}

					@Override
                    public void onJemExecuted() {
						hide(); // hide the popup
                    }
				});
			} else {
				AlertMessageBox alert = new AlertMessageBox(Message.ERROR, "Invalid resource name!", "Please type a valid not-empty resource name");
				alert.open();
			}
		}
	}

	@Override
	public FlexTable getHeader() {
		return new NewResourceHeader(getResource(), this);
	}
	
}
