/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.activity;

import java.util.Collections;
import java.util.Comparator;

import com.google.gwt.core.client.GWT;
import com.sencha.gxt.chart.client.chart.series.Primitives;
import com.sencha.gxt.chart.client.draw.RGB;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;
import com.sencha.gxt.core.client.ValueProvider;

/**
 * @author Andrea "Stock" Stocchero
 * 
 */
public class TimeSeriesMemoryChart extends TimeSeriesChart {

	private static final DataPropertyAccess dataAccess = GWT.create(DataPropertyAccess.class);


	private int max(){
		Data data = Collections.max(getData(), new Comparator<Data>() {
			@Override
            public int compare(Data arg0, Data arg1) {
				int diff = (int)(arg0.getMemory() - arg1.getMemory());
	            return diff;
            }
		});
		int max = (int)data.getMemory();
		
		max = ((int)(max/100) + 1) * 100;
		return max;
	}


	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.activity.TimeSeriesChart#getMaximum()
	 */
    @Override
    public int getMaximum() {
	    return max();
    }


	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.activity.TimeSeriesChart#getValueProvider()
	 */
    @Override
    public ValueProvider<Data, Double> getValueProvider() {
	    return dataAccess.memory();
    }


	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.activity.TimeSeriesChart#getColor()
	 */
    @Override
    public RGB getColor() {
	    return new RGB(194, 0, 36);
    }


	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.activity.TimeSeriesChart#getTitle()
	 */
    @Override
    public String getTitle() {
	    return "megabytes";
    }
    
	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.activity.TimeSeriesChart#getMarker()
	 */
    @Override
    public Sprite getMarker() {
	    return Primitives.circle(0, 0, 4);
    }
}