/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.activity;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.chart.client.chart.Chart;
import com.sencha.gxt.chart.client.chart.Chart.Position;
import com.sencha.gxt.chart.client.chart.Legend;
import com.sencha.gxt.chart.client.chart.axis.CategoryAxis;
import com.sencha.gxt.chart.client.chart.axis.NumericAxis;
import com.sencha.gxt.chart.client.chart.series.LineSeries;
import com.sencha.gxt.chart.client.draw.Color;
import com.sencha.gxt.chart.client.draw.RGB;
import com.sencha.gxt.chart.client.draw.path.PathSprite;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;

/**
 * @author Andrea "Stock" Stocchero
 * 
 */
public abstract class TimeSeriesChart implements IsWidget {

	private static final DataPropertyAccess dataAccess = GWT.create(DataPropertyAccess.class);

	private final Chart<Data> chart = new Chart<Data>();

	private final ListStore<Data> store = new ListStore<Data>(dataAccess.nameKey());
	
	private NumericAxis<Data> axis = null;
	
	private int width = 0;
	
	private int height = 0;
	
	private SimpleContainer panel = new SimpleContainer();

	/**
	 * 
	 * @param type
	 */
	public TimeSeriesChart() {
		chart.setShadowChart(true);
		chart.setAnimated(true);
	}

	/**
	 * @return the width
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * @param width the width to set
	 */
	public void setWidth(int width) {
		this.width = width;
	}

	/**
	 * @return the height
	 */
	public int getHeight() {
		return height;
	}

	/**
	 * @param height the height to set
	 */
	public void setHeight(int height) {
		this.height = height;
	}

	/**
	 * 
	 * @return
	 */
	public List<Data> getData(){
		return store.getAll();
	}
	
	/**
	 * 
	 * @param data
	 */
	public void setData(List<Data> data) {
		boolean redraw = (store.size() == 0);
		if (redraw)
			store.addAll(data);
		else 
			store.replaceAll(data);
		chart.setStore(store);
		if (redraw) {
			createNumericAxis();
			createCategoryAxis();
			createLineSeries();
			createLegend();
		}
		axis.setMaximum(getMaximum());
		chart.redrawChart();
	}
	
	/**
	 * @return max of scale
	 */
	public abstract int getMaximum();
	
	/**
	 * 
	 * @return
	 */
	public abstract ValueProvider<Data, Double> getValueProvider();
	
	/**
	 * 
	 * @return
	 */
	public abstract String getTitle();

	/**
	 * 
	 * @return
	 */
	public abstract RGB getColor();
	/**
	 * 
	 * @return
	 */
	public abstract Sprite getMarker();

	/**
	 * 
	 */
	public Widget asWidget() {
		VerticalLayoutContainer layout = new VerticalLayoutContainer();
		panel.add(layout);

		chart.setLayoutData(new VerticalLayoutData(1, 1));
		layout.add(chart);
		panel.setPixelSize(width, height);
		chart.redrawChart();
		return panel;
	}
	
	/**
	 * 
	 */
	private void createNumericAxis() {
		axis = new NumericAxis<Data>();
		
		String title = getTitle();
		if (title != null){
			TextSprite titleSprite = new TextSprite(title);
			titleSprite.setFontSize(12);
			axis.setTitleConfig(titleSprite);
		}
		
		axis.setPosition(Position.LEFT);
		axis.addField(getValueProvider());
		axis.setMinorTickSteps(1);
		axis.setDisplayGrid(true);
		PathSprite odd = new PathSprite();
		odd.setOpacity(1);
		odd.setFill(new Color("#ddd"));
		odd.setStroke(new Color("#bbb"));
		odd.setStrokeWidth(0.5);
		axis.setGridOddConfig(odd);
		axis.setMinimum(0);

		chart.addAxis(axis);
	}

	/**
	 * 
	 */
	private void createCategoryAxis() {
		CategoryAxis<Data, String> catAxis = new CategoryAxis<Data, String>();
		catAxis.setPosition(Position.BOTTOM);
		catAxis.setField(dataAccess.key());
		TextSprite title = new TextSprite("samples");
		title.setFontSize(12);
		catAxis.setTitleConfig(title);
		chart.addAxis(catAxis);
	}

	/**
	 * 
	 */
	private void createLineSeries() {
		final LineSeries<Data> series = new LineSeries<Data>();
		series.setYAxisPosition(Position.LEFT);
		series.setYField(getValueProvider());
		series.setStroke(getColor());
		series.setStrokeWidth(3);
		series.setShowMarkers(true);
		series.setSmooth(true);
		series.setFill(getColor());

		Sprite marker = getMarker();
		marker.setFill(getColor());
		series.setMarkerConfig(marker);

		series.setHighlighting(true);

		chart.addSeries(series);
	}

	/**
	 * 
	 */
	private void createLegend() {
		final Legend<Data> legend = new Legend<Data>();
		legend.setPosition(Position.RIGHT);
		chart.setLegend(legend);
	}
}