/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.administration.workload.inspector;

import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.node.stats.LightMemberSample;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.TextColumn;

/**
 * Creates all columns to show into table, defening teh sorter too.
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class NodesTable extends AbstractTable<LightMemberSample> {

	
	
	/**
	 *  Empty constructor
	 */
	public NodesTable() {
	}

	/**
	 * Adds all columns to table, defining the sort columns too.
	 */
	@Override
	public IndexedColumnComparator<LightMemberSample> initCellTable(CellTable<LightMemberSample> table) {
		
		/*-------------------------+
		 | IPADDRESS AND PORT      |
		 +-------------------------*/
	    // construct a column that uses anchorRenderer
	   TextColumn<LightMemberSample> name = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample object) {
				return object.getMemberLabel()+" - "+object.getMemberHostname();
			}

		};
		name.setSortable(true);
		table.addColumn(name, "Name");
		/*-------------------------+
		 | TIME                    |
		 +-------------------------*/
		TextColumn<LightMemberSample> time = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return memberSample.getTime();
			}
		};
		time.setSortable(true);
		table.addColumn(time, "Time");

		/*-------------------------+
		 | NUMBER OF JCL           |
		 +-------------------------*/
		TextColumn<LightMemberSample> numberOfJclCheck = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = NumberFormat.getFormat("###,###,##0").format(memberSample.getNumberOfJCLCheck());
				return data;
			}
		};
		numberOfJclCheck.setSortable(true);
		table.addColumn(numberOfJclCheck, "JCL checked");
		
		/*-------------------------+
		 | TOT NUMBER OF JCL       |
		 +-------------------------*/
		TextColumn<LightMemberSample> totNumberOfJclCheck = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = NumberFormat.getFormat("###,###,##0").format(memberSample.getTotalNumberOfJCLCheck());
				return data;
			}
		};
		totNumberOfJclCheck.setSortable(true);
		table.addColumn(totNumberOfJclCheck, "Total JCL checked");		

		/*-------------------------+
		 | NUMBER OF JOB           |
		 +-------------------------*/
		TextColumn<LightMemberSample> numberOfJobSubmitted = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = NumberFormat.getFormat("###,###,##0").format(memberSample.getNumberOfJOBSubmitted());
				return data;
			}
		};
		numberOfJobSubmitted.setSortable(true);
		table.addColumn(numberOfJobSubmitted, "JOB submitted");

		/*-------------------------+
		 | TOT NUMBER OF JOB       |
		 +-------------------------*/
		TextColumn<LightMemberSample> totNumberOfJobSubmitted = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = NumberFormat.getFormat("###,###,##0").format(memberSample.getTotalNumberOfJOBSubmitted());
				return data;
			}
		};
		totNumberOfJobSubmitted.setSortable(true);
		table.addColumn(totNumberOfJobSubmitted, "Total JOB submitted");		

		return new NodesComparator(0);

	}

}