/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.administration.queues;

import com.google.gwt.editor.client.Editor.Path;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.PropertyAccess;

/**
 * @author Andrea "Stock" Stocchero
 *
 */
public interface DataPropertyAccess extends PropertyAccess<Data> {
	/**
	 * @return
	 */
	ValueProvider<Data, Long> entries();

	/**
	 * @return
	 */
	ValueProvider<Data, Long> puts();

	/**
	 * @return
	 */
	ValueProvider<Data, Long> gets();

	/**
	 * @return
	 */
	ValueProvider<Data, Long> removes();

	/**
	 * @return
	 */
	ValueProvider<Data, Long> hits();

	/**
	 * @return
	 */
	ValueProvider<Data, Long> locked();

	/**
	 * @return
	 */
	ValueProvider<Data, Long> lockWaits();

	/**
	 * @return
	 */
	ValueProvider<Data, String> key();

	/**
	 * @return
	 */
	@Path("key")
	ModelKeyProvider<Data> nameKey();
}