/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.administration.nodessystem.inspector;

/**
 * @author Andrea "Stock" Stocchero
 *
 */
public class Data {

	private String key;
	
	private double machineCpuPercent = 0;
	
	private double processCpuPercent = 0;
	
	private long processMemoryUtil = 0;

	/**
	 * 
	 */
	public Data() {
	}

	/**
	 * @return the key
	 */
	public String getKey() {
		return key;
	}

	/**
	 * @param key the key to set
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * @return the machineCpuPercent
	 */
	public double getMachineCpuPercent() {
		return machineCpuPercent;
	}

	/**
	 * @param machineCpuPercent the machineCpuPercent to set
	 */
	public void setMachineCpuPercent(double machineCpuPercent) {
		this.machineCpuPercent = machineCpuPercent;
	}

	/**
	 * @return the processCpuPercent
	 */
	public double getProcessCpuPercent() {
		return processCpuPercent;
	}

	/**
	 * @param processCpuPercent the processCpuPercent to set
	 */
	public void setProcessCpuPercent(double processCpuPercent) {
		this.processCpuPercent = processCpuPercent;
	}


	/**
	 * @return the processMemoryUtil
	 */
	public long getProcessMemoryUtil() {
		return processMemoryUtil;
	}

	/**
	 * @param processMemoryUtil the processMemoryUtil to set
	 */
	public void setProcessMemoryUtil(long processMemoryUtil) {
		this.processMemoryUtil = processMemoryUtil;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
    @Override
    public String toString() {
	    return "Data [key=" + key + ", machineCpuPercent=" + machineCpuPercent + ", processCpuPercent=" + processCpuPercent + ", processMemoryUtil=" + processMemoryUtil + "]";
    }


}