/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.administration.nodesconfig;

import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.Loading;

/**
 * @author Andrea "Stock" Stocchero
 *
 */
public abstract class CommandExecutor {
	
	/**
	 * 
	 */
	public static final int NO_INDEX = -1;
	
	private final Loading loading = new Loading();
	
	private int index = NO_INDEX; 
	
	private String label = null;
	
	private String title = null;
	
	/**
	 * 
	 * @param command
	 */
	public abstract void execute(NodeInfoBean node, ResultPanel resultPanel);


	/**
	 * @return the index
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * @param index the index to set
	 */
	public void setIndex(int index) {
		this.index = index;
	}

	/**
	 * @return the label
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * @param label the label to set
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @param title the title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @return the loading
	 */
	public Loading getLoading() {
		return loading;
	}
	

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
    @Override
    public String toString() {
	    return "CommandExecutor [index=" + index + ", label=" + label + ", title=" + title + "]";
    }
	
}