/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.administration.internalmaps;

import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.node.Queues;
import org.pepstock.jem.node.stats.LightMemberSample;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.TextColumn;

/**
 * Creates all columns to show into table, defening teh sorter too.
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class NodesTable extends AbstractTable<LightMemberSample> {

	private final static long KB = 1024;
	
	private final static long MB = KB * 1024;
	
	/**
	 *  Empty constructor
	 */
	public NodesTable() {
	}

	/**
	 * Adds all columns to table, defining the sort columns too.
	 */
	@Override
	public IndexedColumnComparator<LightMemberSample> initCellTable(CellTable<LightMemberSample> table) {
		
		/*-------------------------+
		 | IPADDRESS AND PORT      |
		 +-------------------------*/
	    // construct a column that uses anchorRenderer
	   TextColumn<LightMemberSample> name = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample object) {
				return object.getMemberLabel()+" - "+object.getMemberHostname();
			}
		};
		name.setSortable(true);
		table.addColumn(name, "Name");
		
		/*-------------------------+
		 | PID                     |
		 +-------------------------*/
		TextColumn<LightMemberSample> pid = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return String.valueOf(memberSample.getPid());
			}
		};
		table.addColumn(pid, "PID");

		/*-------------------------+
		 | TIME                    |
		 +-------------------------*/
		TextColumn<LightMemberSample> time = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return memberSample.getTime();
			}
		};
		table.addColumn(time, "Time");

		/*-------------------------+
		 | Resources               |
		 +-------------------------*/
		TextColumn<LightMemberSample> resourcesEntries = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return  NumberFormat.getFormat("###,###,##0").format(memberSample.getInternalMapsStats().get(Queues.COMMON_RESOURCES_MAP).getOwnedEntryCount());
			}
		};
		resourcesEntries.setSortable(true);
		table.addColumn(resourcesEntries, "Resources");

		/*-------------------------+
		 | Resources Memory Cost   |
		 +-------------------------*/
		TextColumn<LightMemberSample> resourcesMemoryCost = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = null;
				long cost = memberSample.getInternalMapsStats().get(Queues.COMMON_RESOURCES_MAP).getOwnedEntryMemoryCost();
				if (cost < MB){
					cost = cost / KB;
					data = NumberFormat.getFormat("#,##0 KB").format(cost);
				} else {
					cost = cost / MB;
					data = NumberFormat.getFormat("###,##0 MB").format(cost);
				}
				return data;
			}
		};
		resourcesMemoryCost.setSortable(true);
		table.addColumn(resourcesMemoryCost, "Resources Cost");		

		/*-------------------------+
		 | Roles                 |
		 +-------------------------*/
		TextColumn<LightMemberSample> rolesEntries = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return  NumberFormat.getFormat("###,###,##0").format(memberSample.getInternalMapsStats().get(Queues.ROLES_MAP).getOwnedEntryCount());
			}
		};
		rolesEntries.setSortable(true);
		table.addColumn(rolesEntries, "Roles");

		/*-------------------------+
		 | roles Memory Cost     |
		 +-------------------------*/
		TextColumn<LightMemberSample> rolesMemoryCost = new TextColumn<LightMemberSample>() {
			
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = null;
				long cost = memberSample.getInternalMapsStats().get(Queues.ROLES_MAP).getOwnedEntryMemoryCost();
				if (cost < MB){
					cost = cost / KB;
					data = NumberFormat.getFormat("#,##0 KB").format(cost);
				} else {
					cost = cost / MB;
					data = NumberFormat.getFormat("###,##0 MB").format(cost);
				}
				return data;
			}
		};
		rolesMemoryCost.setSortable(true);
		table.addColumn(rolesMemoryCost, "Roles Cost");		

		/*-------------------------+
		 | Routed                  |
		 +-------------------------*/
		TextColumn<LightMemberSample> routedEntries = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return  NumberFormat.getFormat("###,###,##0").format(memberSample.getInternalMapsStats().get(Queues.ROUTED_QUEUE).getOwnedEntryCount());
			}
		};
		routedEntries.setSortable(true);
		table.addColumn(routedEntries, "Routed");

		/*-------------------------+
		 | Routed  Memory Cost     |
		 +-------------------------*/
		TextColumn<LightMemberSample> routedMemoryCost = new TextColumn<LightMemberSample>() {
			
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = null;
				long cost = memberSample.getInternalMapsStats().get(Queues.ROUTED_QUEUE).getOwnedEntryMemoryCost();
				if (cost < MB){
					cost = cost / KB;
					data = NumberFormat.getFormat("#,##0 KB").format(cost);
				} else {
					cost = cost / MB;
					data = NumberFormat.getFormat("###,##0 MB").format(cost);
				}
				return data;
			}
		};
		routedMemoryCost.setSortable(true);
		table.addColumn(routedMemoryCost, "Routed Cost");		

		/*-------------------------+
		 | Statistics                 |
		 +-------------------------*/
		TextColumn<LightMemberSample> statisticsEntries = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return  NumberFormat.getFormat("###,###,##0").format(memberSample.getInternalMapsStats().get(Queues.STATS_MAP).getOwnedEntryCount());
			}
		};
		statisticsEntries.setSortable(true);
		table.addColumn(statisticsEntries, "Statistics");

		/*-------------------------+
		 | Statistics  Memory Cost     |
		 +-------------------------*/
		TextColumn<LightMemberSample> statisticsMemoryCost = new TextColumn<LightMemberSample>() {
			
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = null;
				long cost = memberSample.getInternalMapsStats().get(Queues.STATS_MAP).getOwnedEntryMemoryCost();
				if (cost < MB){
					cost = cost / KB;
					data = NumberFormat.getFormat("#,##0 KB").format(cost);
				} else {
					cost = cost / MB;
					data = NumberFormat.getFormat("###,##0 MB").format(cost);
				}
				return data;
			}
		};
		statisticsMemoryCost.setSortable(true);
		table.addColumn(statisticsMemoryCost, "Statistics Cost");
		
		/*-------------------------+
		 | UserPref                 |
		 +-------------------------*/
		TextColumn<LightMemberSample> userPrefEntries = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return  NumberFormat.getFormat("###,###,##0").format(memberSample.getInternalMapsStats().get(Queues.USER_PREFERENCES_MAP).getOwnedEntryCount());
			}
		};
		userPrefEntries.setSortable(true);
		table.addColumn(userPrefEntries, "UserPref");

		/*-------------------------+
		 | UserPref  Memory Cost     |
		 +-------------------------*/
		TextColumn<LightMemberSample> userPrefMemoryCost = new TextColumn<LightMemberSample>() {
			
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = null;
				long cost = memberSample.getInternalMapsStats().get(Queues.USER_PREFERENCES_MAP).getOwnedEntryMemoryCost();
				if (cost < MB){
					cost = cost / KB;
					data = NumberFormat.getFormat("#,##0 KB").format(cost);
				} else {
					cost = cost / MB;
					data = NumberFormat.getFormat("###,##0 MB").format(cost);
				}
				return data;
			}
		};
		userPrefMemoryCost.setSortable(true);
		table.addColumn(userPrefMemoryCost, "UserPref Cost");
		
		return new NodesComparator(0);

	}

}