/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.administration.gfs;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.chart.client.chart.Chart;
import com.sencha.gxt.chart.client.chart.Chart.Position;
import com.sencha.gxt.chart.client.chart.Legend;
import com.sencha.gxt.chart.client.chart.series.PieSeries;
import com.sencha.gxt.chart.client.chart.series.Series.LabelPosition;
import com.sencha.gxt.chart.client.chart.series.SeriesLabelConfig;
import com.sencha.gxt.chart.client.chart.series.SeriesLabelProvider;
import com.sencha.gxt.chart.client.chart.series.SeriesToolTipConfig;
import com.sencha.gxt.chart.client.draw.RGB;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite.TextAnchor;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite.TextBaseline;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.StringLabelProvider;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;

/**
 * @author Andrea "Stock" Stocchero
 * 
 */
public class PieChart implements IsWidget {

	private static final DataPropertyAccess dataAccess = GWT.create(DataPropertyAccess.class);

	/**
	 * 
	 */
	private final Chart<Data> chart = new Chart<Data>();

	private final ListStore<Data> store = new ListStore<Data>(dataAccess.nameKey());
	
	private RGB blue = new RGB(164, 175, 210);
	
	private RGB red = RGB.RED;
	
	private int width = 0;
	
	private int height = 0;


	/**
	 * 
	 * @param type
	 */
	public PieChart() {
		chart.setShadowChart(true);

	}

	/**
	 * @return the width
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * @param width the width to set
	 */
	public void setWidth(int width) {
		this.width = width;
	}

	/**
	 * @return the height
	 */
	public int getHeight() {
		return height;
	}

	/**
	 * @param height the height to set
	 */
	public void setHeight(int height) {
		this.height = height;
	}

	/**
	 * 
	 * @param data
	 */
	public void setData(List<Data> data) {
		boolean redraw = (store.size() == 0);
		if (redraw)
			store.addAll(data);
		else 
			store.replaceAll(data);
		chart.setStore(store);
		if (redraw) {
			createPie();
			createLegend();
		}
		chart.redrawChart();
	}

	
	/**
	 * 
	 */
	public Widget asWidget() {
		SimpleContainer panel = new SimpleContainer();

		panel.setPixelSize(width, height);

		VerticalLayoutContainer layout = new VerticalLayoutContainer();
		panel.add(layout);

		chart.setLayoutData(new VerticalLayoutData(1, 1));
		layout.add(chart);
		return panel;
	}


	/**
	 * 
	 */
	private void createPie() {
	    final PieSeries<Data> series = new PieSeries<Data>();
	    series.setAngleField(dataAccess.value());
	    series.setDonut(35);
    
	    series.addColor(blue);
	    series.addColor(red);
	    TextSprite textConfig = new TextSprite();
	    textConfig.setFont("Arial");
	    textConfig.setTextBaseline(TextBaseline.MIDDLE);
	    textConfig.setFontSize(18);
	    textConfig.setTextAnchor(TextAnchor.MIDDLE);
	    textConfig.setZIndex(15);
	    SeriesLabelConfig<Data> labelConfig = new SeriesLabelConfig<Data>();
	    labelConfig.setSpriteConfig(textConfig);
	    labelConfig.setLabelPosition(LabelPosition.START);
	    labelConfig.setValueProvider(dataAccess.key(), new StringLabelProvider<String>());
	    series.setLabelConfig(labelConfig);
	    series.setHighlighting(true);
	    series.setLegendValueProvider(dataAccess.key(),new StringLabelProvider<String>()); 

	    chart.addSeries(series);
	    
	    final SeriesToolTipConfig<Data> config = new SeriesToolTipConfig<Data>();
	    config.setLabelProvider(new SeriesLabelProvider<Data>() {
			
			@Override
			public String getLabel(Data item, ValueProvider<? super Data, ? extends Number> valueProvider) {
				return item.getKey()+": "+NumberFormat.getFormat("##0.00 %").format((double)item.getPercent())+", "+NumberFormat.getFormat("###,###,##0 MB").format((double)item.getValue()/1024);
			}
		});
	    series.setToolTipConfig(config);
	}
	
	/**
	 * 
	 */
	private void createLegend() {
		final Legend<Data> legend = new Legend<Data>();
		legend.setPosition(Position.RIGHT);
//		legend.setItemHighlighting(true);
//		legend.setItemHiding(true);
		chart.setLegend(legend);
	}
}