/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.administration.current;

import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.node.Queues;
import org.pepstock.jem.node.stats.LightMemberSample;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.TextColumn;

/**
 * Creates all columns to show into table, defening teh sorter too.
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class NodesTable extends AbstractTable<LightMemberSample> {

	private final static long KB = 1024;
	
	private final static long MB = KB * 1024;
	
	/**
	 *  Empty constructor
	 */
	public NodesTable() {
	}

	/**
	 * Adds all columns to table, defining the sort columns too.
	 */
	@Override
	public IndexedColumnComparator<LightMemberSample> initCellTable(CellTable<LightMemberSample> table) {
		
		/*-------------------------+
		 | IPADDRESS AND PORT      |
		 +-------------------------*/
	    // construct a column that uses anchorRenderer
	   TextColumn<LightMemberSample> name = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample object) {
				return object.getMemberLabel()+" - "+object.getMemberHostname();
			}
		};
		name.setSortable(true);
		table.addColumn(name, "Name");
		
		/*-------------------------+
		 | PID                     |
		 +-------------------------*/
		TextColumn<LightMemberSample> pid = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return String.valueOf(memberSample.getPid());
			}
		};
		table.addColumn(pid, "PID");

		/*-------------------------+
		 | TIME                    |
		 +-------------------------*/
		TextColumn<LightMemberSample> time = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return memberSample.getTime();
			}
		};
		table.addColumn(time, "Time");

		/*-------------------------+
		 | Input                   |
		 +-------------------------*/
		TextColumn<LightMemberSample> inputEntries = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return  NumberFormat.getFormat("###,###,##0").format(memberSample.getMapsStats().get(Queues.INPUT_QUEUE).getOwnedEntryCount());
			}
		};
		inputEntries.setSortable(true);
		table.addColumn(inputEntries, "Input");

		/*-------------------------+
		 | Input Memory Cost       |
		 +-------------------------*/
		TextColumn<LightMemberSample> inputMemoryCost = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = null;
				long cost = memberSample.getMapsStats().get(Queues.INPUT_QUEUE).getOwnedEntryMemoryCost();
				if (cost < MB){
					cost = cost / KB;
					data = NumberFormat.getFormat("#,##0 KB").format(cost);
				} else {
					cost = cost / MB;
					data = NumberFormat.getFormat("###,##0 MB").format(cost);
				}
				return data;
			}
		};
		inputMemoryCost.setSortable(true);
		table.addColumn(inputMemoryCost, "Input Cost");		

		/*-------------------------+
		 | Running                 |
		 +-------------------------*/
		TextColumn<LightMemberSample> runningEntries = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return  NumberFormat.getFormat("###,###,##0").format(memberSample.getMapsStats().get(Queues.RUNNING_QUEUE).getOwnedEntryCount());
			}
		};
		runningEntries.setSortable(true);
		table.addColumn(runningEntries, "Running");

		/*-------------------------+
		 | running Memory Cost     |
		 +-------------------------*/
		TextColumn<LightMemberSample> runningMemoryCost = new TextColumn<LightMemberSample>() {
			
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = null;
				long cost = memberSample.getMapsStats().get(Queues.RUNNING_QUEUE).getOwnedEntryMemoryCost();
				if (cost < MB){
					cost = cost / KB;
					data = NumberFormat.getFormat("#,##0 KB").format(cost);
				} else {
					cost = cost / MB;
					data = NumberFormat.getFormat("###,##0 MB").format(cost);
				}
				return data;
			}
		};
		runningMemoryCost.setSortable(true);
		table.addColumn(runningMemoryCost, "Running Cost");		

		/*-------------------------+
		 | Output                  |
		 +-------------------------*/
		TextColumn<LightMemberSample> outputEntries = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return  NumberFormat.getFormat("###,###,##0").format(memberSample.getMapsStats().get(Queues.OUTPUT_QUEUE).getOwnedEntryCount());
			}
		};
		outputEntries.setSortable(true);
		table.addColumn(outputEntries, "Output");

		/*-------------------------+
		 | Output  Memory Cost     |
		 +-------------------------*/
		TextColumn<LightMemberSample> outputMemoryCost = new TextColumn<LightMemberSample>() {
			
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = null;
				long cost = memberSample.getMapsStats().get(Queues.OUTPUT_QUEUE).getOwnedEntryMemoryCost();
				if (cost < MB){
					cost = cost / KB;
					data = NumberFormat.getFormat("#,##0 KB").format(cost);
				} else {
					cost = cost / MB;
					data = NumberFormat.getFormat("###,##0 MB").format(cost);
				}
				return data;
			}
		};
		outputMemoryCost.setSortable(true);
		table.addColumn(outputMemoryCost, "Output Cost");		

		/*-------------------------+
		 | Routing                 |
		 +-------------------------*/
		TextColumn<LightMemberSample> routingEntries = new TextColumn<LightMemberSample>() {
			@Override
			public String getValue(LightMemberSample memberSample) {
				return  NumberFormat.getFormat("###,###,##0").format(memberSample.getMapsStats().get(Queues.ROUTING_QUEUE).getOwnedEntryCount());
			}
		};
		routingEntries.setSortable(true);
		table.addColumn(routingEntries, "Routing");

		/*-------------------------+
		 | Routing  Memory Cost     |
		 +-------------------------*/
		TextColumn<LightMemberSample> routingMemoryCost = new TextColumn<LightMemberSample>() {
			
			@Override
			public String getValue(LightMemberSample memberSample) {
				String data = null;
				long cost = memberSample.getMapsStats().get(Queues.ROUTING_QUEUE).getOwnedEntryMemoryCost();
				if (cost < MB){
					cost = cost / KB;
					data = NumberFormat.getFormat("#,##0 KB").format(cost);
				} else {
					cost = cost / MB;
					data = NumberFormat.getFormat("###,##0 MB").format(cost);
				}
				return data;
			}
		};
		routingMemoryCost.setSortable(true);
		table.addColumn(routingMemoryCost, "Routing Cost");
		return new NodesComparator(0);

	}

}