/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.panels.administration.current;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.chart.client.chart.Chart;
import com.sencha.gxt.chart.client.chart.Chart.Position;
import com.sencha.gxt.chart.client.chart.Legend;
import com.sencha.gxt.chart.client.chart.axis.CategoryAxis;
import com.sencha.gxt.chart.client.chart.axis.NumericAxis;
import com.sencha.gxt.chart.client.chart.series.BarSeries;
import com.sencha.gxt.chart.client.chart.series.SeriesLabelProvider;
import com.sencha.gxt.chart.client.chart.series.SeriesToolTipConfig;
import com.sencha.gxt.chart.client.draw.RGB;
import com.sencha.gxt.chart.client.draw.sprite.TextSprite;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;

/**
 * @author Andrea "Stock" Stocchero
 * 
 */
public class BarChart implements IsWidget {

	private static final DataPropertyAccess dataAccess = GWT.create(DataPropertyAccess.class);

	private static final String QUEUES_AXIS = "Queues";

	/**
	 * 
	 */
	public static final int ENTRIES = 0;

	private final Chart<Data> chart = new Chart<Data>();

	private final ListStore<Data> store = new ListStore<Data>(dataAccess.nameKey());
	
	private NumericAxis<Data> axis = null;
	
	private int width = 0;
	
	private int height = 0;

	private int type = ENTRIES;


	/**
	 * 
	 * @param type
	 */
	public BarChart(int type) {
		setType(type);
		chart.setShadowChart(true);
		chart.setAnimated(true);
	}

	/**
	 * @return the type
	 */
	public int getType() {
		return type;
	}

	/**
	 * @param type
	 *            the type to set
	 */
	public void setType(int type) {
		this.type = type;
	}

	/**
	 * @return the width
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * @param width the width to set
	 */
	public void setWidth(int width) {
		this.width = width;
	}

	/**
	 * @return the height
	 */
	public int getHeight() {
		return height;
	}

	/**
	 * @param height the height to set
	 */
	public void setHeight(int height) {
		this.height = height;
	}

	/**
	 * 
	 * @param data
	 */
	public void setData(List<Data> data) {
		boolean redraw = (store.size() == 0);
		if (redraw)
			store.addAll(data);
		else 
			store.replaceAll(data);
		chart.setStore(store);
		if (redraw) {
			createNumericAxis();
			createCategoryAxis();
			createBars();
			createLegend();
		}
		axis.setMaximum(max());
		chart.redrawChart();
		
		
	}

	
	private int max(){
		Data data = Collections.max(store.getAll(), new Comparator<Data>() {
			@Override
            public int compare(Data arg0, Data arg1) {
				long diff = 0;
//	            if (getType() == ENTRIES){
//	            	diff = arg0.getEntries() - arg1.getEntries();
//	            } else {
	            diff = arg0.getEntries() - arg1.getEntries();
//	            }
	            return (int)diff;
            }
		});
		// comment to avoid FindBugs findings
//		long max = (getType() == ENTRIES) ? data.getEntries() : data.getEntries();
		long max = data.getEntries();
		
		max = ((long)(max/10) + 1) * 10;
		return (int)max;
	}
	/**
	 * 
	 */
	public Widget asWidget() {
		SimpleContainer panel = new SimpleContainer();

		panel.setPixelSize(width, height);

		VerticalLayoutContainer layout = new VerticalLayoutContainer();
		panel.add(layout);

		chart.setLayoutData(new VerticalLayoutData(1, 1));
		layout.add(chart);
		return panel;
	}

	/**
	 * 
	 */
	private void createNumericAxis() {
		axis = new NumericAxis<Data>();
		axis.setPosition(Position.BOTTOM);
		// comment to avoid FindBugs findings
//		axis.addField((getType() == ENTRIES) ? dataAccess.entries() : dataAccess.entries());
		axis.addField(dataAccess.entries());

		TextSprite titleSprite = new TextSprite("Entries");
		titleSprite.setFontSize(12);
		axis.setTitleConfig(titleSprite);

		axis.setMinorTickSteps(1);
		axis.setDisplayGrid(true);
		axis.setMinimum(0);

		chart.addAxis(axis);
	}

	/**
	 * 
	 */
	private void createCategoryAxis() {
		CategoryAxis<Data, String> catAxis = new CategoryAxis<Data, String>();
		catAxis.setPosition(Position.LEFT);
		catAxis.setField(dataAccess.key());

		TextSprite title = new TextSprite(QUEUES_AXIS);
		title.setFontSize(12);
		catAxis.setTitleConfig(title);
		chart.addAxis(catAxis);
	}

	/**
	 * 
	 */
	private void createBars() {
	    final BarSeries<Data> bar = new BarSeries<Data>();
	    bar.setYAxisPosition(Position.BOTTOM);
//	    bar.addYField((getType() == ENTRIES) ? dataAccess.entries() : dataAccess.entries());
	    bar.addYField(dataAccess.entries());
	    bar.addColor(new RGB(148,174,10));
	    bar.setHighlighting(true);
	    chart.addSeries(bar);
	    
	    final SeriesToolTipConfig<Data> config = new SeriesToolTipConfig<Data>();
	    config.setLabelProvider(new SeriesLabelProvider<Data>() {
			
			@Override
			public String getLabel(Data item, ValueProvider<? super Data, ? extends Number> valueProvider) {
				return "Entries: "+item.getEntries();
			}
		});
	    bar.setToolTipConfig(config);
	}

	private void createLegend() {
		final Legend<Data> legend = new Legend<Data>();
		legend.setPosition(Position.RIGHT);
//		legend.setItemHighlighting(true);
//		legend.setItemHiding(true);
		chart.setLegend(legend);
	}

}