/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.commons;

import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.notify.MessagesCollection;
import org.pepstock.jem.gwt.client.notify.ToastMessage;
import org.pepstock.jem.log.Message;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Event.NativePreviewEvent;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;



/**
 * A javascript-style Window.alert() box
 * @author Andrea "Stock" Stocchero
 */
public class Toast extends PopupPanel {
	
	static {
		Styles.INSTANCE.toast().ensureInjected();
	}
	
	private boolean timerStopped = false;
	
	/**
	 * @param level the message level, any of {@link Message}
	 * @param message the message description
	 * @param title the message box title
	 */
	public Toast(int level, String message, String title) {
		this(message, title);
		String theStyle;
		switch (level) {
		case Message.WARNING:
			theStyle = Styles.INSTANCE.toast().yellow();
			break;
		case Message.ERROR:
			theStyle = Styles.INSTANCE.toast().red();
			break;
		default:
			theStyle = Styles.INSTANCE.toast().lightGreen();
			break;
		}
		addStyleName(theStyle);
		
		ToastMessage tMessage = new ToastMessage();
		tMessage.setLevel(level);
		tMessage.setMessage(message);
		tMessage.setTitle(title);
		
		MessagesCollection.add(tMessage);
	}

	/**
	 * Apply the provided style to toast 
	 * @param style the style
	 * @param message the message description
	 * @param title the toast title
	 */
	public Toast(String style, String message, String title) {
		this(message, title);
		addStyleName(style);
	}

	protected Toast(String message, String title) {
		setStyleName(Styles.INSTANCE.toast().main());
		final VerticalPanel panel = new VerticalPanel();
		panel.setSpacing(2);

		if (title != null) {
			final Label t = new Label(title);
			t.addStyleName(Styles.INSTANCE.toast().title());
			panel.add(t);
		}

		if (message != null) {
//			final Label m = new Label(message);
			final HTML m = new HTML(message);
			m.addStyleName(Styles.INSTANCE.toast().message());
			panel.add(m);
		}
		int maxWidth = Window.getClientWidth() * 75 / 100;
		// 	max-width: 200px;
		getElement().getStyle().setPropertyPx("maxWidth", maxWidth);

 		setWidget(panel);
	}

	@Override
	public final void show() {

		//Window.alert(getElement().getStyle().getProperty("max-width"));

		setVisible(false);
		super.show();
		// needs deferred task 
		// otherwsie browser don't apply styles
	    Scheduler scheduler = Scheduler.get();
	    scheduler.scheduleDeferred(new ScheduledCommand() {

			@Override
            public void execute() {
				// position calculation
				/*
				int left = Window.getClientWidth() - getOffsetWidth() - Sizes.MAIN_VERTICAL_PANEL_PADDING_TOP_LEFT_RIGHT - 2;
				int top = Window.getClientHeight() - getOffsetHeight() - Sizes.FOOTER - Sizes.MAIN_VERTICAL_PANEL_PADDING_BOTTOM - 2;
				*/
				int left = (Window.getClientWidth() - getOffsetWidth())/2;
				int top = Sizes.HEADER + (Sizes.TABBAR_HEIGHT_PX + Sizes.MAIN_VERTICAL_PANEL_PADDING_TOP_LEFT_RIGHT)/2 - getOffsetHeight(); 
				
				setPopupPosition(left, top);
				setVisible(true);
				
				Timer t = new Timer() {
					@Override
					public void run() {
						if (!timerStopped){
							Toast.this.hide();
						}
					}
				};

				// Schedule the timer to close the popup in 3 seconds.
				t.schedule(3000);
            }
	    	
	    });
	}	
	
	@Override
	protected void onPreviewNativeEvent(NativePreviewEvent event) {
		super.onPreviewNativeEvent(event);
		switch (event.getTypeInt()){
		case Event.ONKEYDOWN:
			if (event.getNativeEvent().getKeyCode() == KeyCodes.KEY_ESCAPE){
				hide();
			}
			break;
		case Event.ONCLICK:
			if (isShowing()){
				boolean insidePopup = Sizes.isEventInsideWidget(event.getNativeEvent(), this);
				if (!insidePopup){
					hide();
				}
			}
			break;
		case Event.ONMOUSEOVER:
			if (isShowing()){
				boolean insidePopup = Sizes.isEventInsideWidget(event.getNativeEvent(), this);
				if (insidePopup){
					timerStopped = true;
				}
			}
			break;
		case Event.ONMOUSEOUT:
			if (isShowing() && timerStopped){
				boolean insidePopup = Sizes.isEventInsideWidget(event.getNativeEvent(), this);
				// if inside of popup, ignore the event (generates by label of message and title)
				if (!insidePopup){
					hide();
				}
			}
			break;
			
		default:
			return;
		}
	}
}