/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;

/**
 * It's the "loading" popup panel which is showing a animated gif.
 *     
 * @author Andrea "Stock" Stocchero
 * 
 */
public class Loading extends PopupPanel {

	static {
		Styles.INSTANCE.loading().ensureInjected();
	}

	
	/**
	 * Default delay
	 */
	public static final int DEFAULT_DELAY = 100;
	
	/**
	 * No delay
	 */
	public static final int NO_DELAY = -1;
	
	private final FlowPanel container = new FlowPanel();
	
	private Timer timer = null; 
	
	private int delay = DEFAULT_DELAY;


	/**
	 * Constructs the component.
	 */
	public Loading() {
		super(true);
		setGlassEnabled(true);
		setAnimationEnabled(false);
		// animated image
		final Image ajaxImage = new Image(Images.INSTANCE.loading());
		final Grid grid = new Grid(1, 2);
		grid.setWidget(0, 0, ajaxImage);
		grid.setText(0, 1, "Loading...");
		this.container.add(grid);
		add(this.container);
			// add the timer. Shows the popup only if "stopProcessing" is not called in meantime.
		// fixes 5 seconds to wait

	}
	

	/**
	 * Gets delay to show popup
	 * @return the delay
	 */
	public int getDelay() {
		return delay;
	}


	/**
	 * Sets delay to show popup
	 * @param delay the delay to set
	 */
	public void setDelay(int delay) {
		this.delay = delay;
	}


	/**
	 * Called when the remote call is ended. Sets show to false, because if the timer is still running,
	 * timer doesn't show the panel. 
	 */
	public void stopProcessing() {
		if (delay != NO_DELAY){
			if (timer != null){
				timer.cancel();
				timer = null;
			}
		}
		hide();
	}

	/**
	 * Called before the remote call starts. Start a timer to avoid to show itself for quick requests.
	 */
	public void startProcessing() {
		if (delay != NO_DELAY){
			// fixes 5 seconds to wait
			timer = new Timer() {
				@Override
				public void run() {
					center();
				}
			};		
			timer.schedule(delay);
		} else {
			center();			
		}
	}
}