package org.pepstock.jem.gwt.client.commons;

import java.util.Collection;

/**
 * Utility class to handle CSV data
 * @author Marco "Fuzzo" Cuccato
 *
 */
public class CSVUtil {

	/**
	 * 
	 */
    public static final String COMMA_STRING = ",";
    /**
     * 
     */
    public static final String COMMA_SPACE_STRING = ", ";
    /**
     * 
     */
    public static final char COMMA_CHAR = ',';
    /**
     * 
     */
    public static final String NULL = "null";
    
    private CSVUtil() {
    }
    
    /**
     * Creates CSV phrase from objects
     * @param objects objects to be returned in phrase
     * @return a string, with each object separated by <code>,</code>
     */
    public static String getCSVPhrase(Collection<?> objects) {
        return getCSVPhrase(objects, COMMA_CHAR);
    }
    
    /**
     * Creates CSV phrase from objects
     * @param objects objects to be returned in phrase
     * @param separator the char to be used as separator
     * @return a string, with each object separated by separator 
     */
    public static String getCSVPhrase(Collection<?> objects, char separator) {
        return getCSVPhrase(objects, String.valueOf(separator));
    }
    
    /**
     * Creates CSV phrase from objects
     * @param objects objects to be returned in phrase
     * @param separator the string to be used as separator
     * @return a string, with each object separated by separator 
     */
    public static String getCSVPhrase(Collection<?> objects, String separator) {
        StringBuffer s = new StringBuffer();
        if (!objects.isEmpty()) {
            for (Object o: objects) {
                if (o != null)
                    s.append(o.toString());
                else
                    s.append(NULL);
                s.append(separator);
            }
            s.setLength(s.length()-separator.length());
        }
        return s.toString();
    }
    
    /**
     * Creates CSV phrase from objects
     * @param objects objects to be returned in phrase
     * @return a string, with each object separated by <code>,</code>
     */
    public static String getCSVPhrase(Object[] objects) {
        return getCSVPhrase(objects, COMMA_CHAR);
    }
    
    /**
     * Creates CSV phrase from objects
     * @param objects objects to be returned in phrase
     * @param separator the char to be used as separator
     * @return a string, with each object separated by separator 
     */
    public static String getCSVPhrase(Object[] objects, char separator) {
        return getCSVPhrase(objects, String.valueOf(separator));
    }
    
    /**
     * Creates CSV phrase from objects
     * @param objects objects to be returned in phrase
     * @param separator the string to be used as separator
     * @return a string, with each object separated by separator 
     */
    public static String getCSVPhrase(Object[] objects, String separator) {
        StringBuffer s = new StringBuffer();
        if (objects.length > 0) {
            for (Object o: objects) {
                if (o != null)
                    s.append(o.toString());
                else
                    s.append(NULL);
                s.append(separator);
            }
            s.setLength(s.length()-separator.length());
        }
        return s.toString();
    }
    
    /**
     * Split objects in CSVPhrase into array
     * @param CSVPhrase the csv string representing the objects, separated by comma
     * @return a String[]
     */
    public static String[] split(String CSVPhrase) {
        return split(CSVPhrase, COMMA_STRING);
    }
    
    /**
     * Split objects in CSVPhrase into array
     * @param CSVPhrase the csv string representing the objects
     * @param separator the separator char used in CSVPhrase
     * @return a String[]
     */
    public static String[] split(String CSVPhrase, char separator) {
        return split(CSVPhrase, new Character(separator).toString());
    }

    /**
     * Split objects in CSVPhrase into array
     * @param CSVPhrase the csv string representing the objects
     * @param separator the separator string used in CSVPhrase
     * @return a String[]
     */
    public static String[] split(String CSVPhrase, String separator) {
        return CSVPhrase.split(separator);
    }

    /**
     * Split and trim objects in CSVPhrase into array
     * @param CSVPhrase the csv string representing the objects
     * @return a String[]
     */
    public static String[] splitAndTrim(String CSVPhrase) {
        String[] toReturn = split(CSVPhrase);
        trim(toReturn);
        return toReturn;
    }

    /**
     * Split and trim objects in CSVPhrase into array
     * @param CSVPhrase the csv string representing the objects
     * @param separator the separator used in phrase
     * @return a String[]
     */
    public static String[] splitAndTrim(String CSVPhrase, char separator) {
        String[] toReturn = split(CSVPhrase, separator);
        trim(toReturn);
        return toReturn;
    }

    /**
     * Split and trim objects in CSVPhrase into array
     * @param CSVPhrase the csv string representing the objects
     * @param separator the separator used in phrase
     * @return a String[]
     */
    public static String[] splitAndTrim(String CSVPhrase, String separator) {
        String[] toReturn = split(CSVPhrase, separator);
        trim(toReturn);
        return toReturn;
    }

    /**
     * Trim all strings contained in the array
     * @param strings a String[] containing String to be trimmed
     */
    public static void trim(String[] strings) {
        if (strings != null) {
            for (int i=0; i < strings.length; i++) {
                strings[i] = strings[i].trim();
            }
        }
    }
}
