/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client.commons;

import org.pepstock.jem.log.Message;

/**
 * A toast extension to show alerts with different levels
 * 
 * @author Andrea "Stock" Stocchero
 */
public class AlertMessageBox extends Toast {

	/**
	 * Constructs object with level, title and message
	 * @param level the message level, any of {@link Message}
	 * @param title the message box title
	 * @param message the message description
	 */
	public AlertMessageBox(int level, String title, String message) {
		super(level, message, title);
	}

	/**
	 * Shows the TOAST!
	 */
	public void open(){
		super.show();
	}
}