/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013  Marco "Fuzzo" Cuccato
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.gwt.client;

import org.pepstock.jem.gwt.client.about.AboutPanel;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.commons.SharedObjects;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.notify.NotifyPanel;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.log.Message;
import org.pepstock.jem.node.About;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;

/**
 * This is the footer element of Jem home screen
 * @author Marco "Fuzzo" Cuccato
 */
//public class Footer extends HTML {

public class Footer extends HorizontalPanel implements ResizeCapable{

	static {
		Styles.INSTANCE.common().ensureInjected();
	}
	
	
	private final HTML license = new HTML(SharedObjects.LICENSE);

	private static final int NOTIFY_IMAGE_SIZE = 22; // 16px of images plus 6 for padding
	
	/**
	 *
	 */
	public Footer() {
		license.addStyleName(Styles.INSTANCE.common().footer());
		license.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				//Window.open("http://www.pepstock.org/", "_blank", "");
			    Scheduler scheduler = Scheduler.get();
			    scheduler.scheduleDeferred(new ScheduledCommand() {
					
					@Override
					public void execute() {
						Services.INFO_SERVICE.getAbout(new ServiceAsyncCallback<About>() {

							@Override
							public void onJemFailure(Throwable caught) {
								AlertMessageBox alert = new AlertMessageBox(Message.ERROR, "Search error!", 
										caught.getMessage());
								alert.open();
							}

							@Override
							public void onJemSuccess(About result) {
								// sets data to table to show it
								AboutPanel p = new AboutPanel(result);
								p.center();
							}

							@Override
                            public void onJemExecuted() {
                            }
						});
					
					}
			    });
			}
		});
		
		Image image = new Image(Images.INSTANCE.notifySmall());
		image.setTitle("Messages history");
		image.addStyleName(Styles.INSTANCE.common().notifyImage());
		image.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				// sets data to table to show it
				NotifyPanel p = new NotifyPanel();
				p.center();
			}
		});
		
		add(license);
		add(image);
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.gwt.client.ResizeCapable#onResize(int, int)
	 */
    @Override
    public void onResize(int availableWidth, int availableHeight) {
	   license.setSize(Sizes.toString(availableWidth - NOTIFY_IMAGE_SIZE), Sizes.toString(availableHeight));
    }
	
}