/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.streams;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.streams.JPPFByteArrayOutputStream;
import org.slf4j.Logger;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static void close(Closeable closeable) throws IOException {
        closeable.close();
    }

    public static void closeSilent(Closeable closeable) {
        StreamUtils.close(closeable, null);
    }

    public static void close(Closeable closeable, Logger log) {
        block4: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (log == null) break block4;
                    String s = "unable to close stream/reader/writer: " + ExceptionUtils.getMessage(e);
                    if (log.isDebugEnabled()) {
                        log.debug(s, (Throwable)e);
                    }
                    log.warn(s);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getInputStreamAsByte(InputStream is) throws IOException {
        byte[] buffer = new byte[4096];
        byte[] result = null;
        JPPFByteArrayOutputStream baos = new JPPFByteArrayOutputStream();
        boolean end = false;
        try {
            while (!end) {
                int n = is.read(buffer, 0, buffer.length);
                if (n < 0) {
                    end = true;
                    continue;
                }
                baos.write(buffer, 0, n);
            }
            baos.flush();
            result = ((ByteArrayOutputStream)baos).toByteArray();
        }
        finally {
            try {
                is.close();
            }
            finally {
                baos.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        try {
            int n;
            byte[] bytes = new byte[4096];
            while ((n = is.read(bytes)) > 0) {
                os.write(bytes, 0, n);
            }
            os.flush();
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    public static void waitKeyPressed() throws Exception {
        StreamUtils.waitKeyPressed("press any key to continue ...");
    }

    public static void waitKeyPressed(String message) throws Exception {
        System.out.println(message);
        System.in.read();
    }
}

