/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.streams;

import java.io.IOException;
import java.io.OutputStream;
import org.jppf.utils.streams.NotifyingStreamCallback;

public class NotifyingOutputStream
extends OutputStream {
    private OutputStream delegate;
    private NotifyingStreamCallback callback;

    public NotifyingOutputStream(OutputStream delegate, NotifyingStreamCallback callback) {
        if (delegate == null) {
            throw new IllegalArgumentException("output stream cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("the callback cannot be null");
        }
        this.delegate = delegate;
        this.callback = callback;
    }

    @Override
    public void write(int n) throws IOException {
        this.delegate.write(n);
        this.callback.bytesNotification(1L);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
        this.callback.bytesNotification(len);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }
}

