/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.streams;

import java.io.IOException;
import java.io.InputStream;
import org.jppf.utils.streams.NotifyingStreamCallback;

public class NotifyingInputStream
extends InputStream {
    private InputStream delegate;
    private NotifyingStreamCallback callback;

    public NotifyingInputStream(InputStream delegate, NotifyingStreamCallback callback) {
        if (delegate == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("the callback cannot be null");
        }
        this.delegate = delegate;
        this.callback = callback;
    }

    @Override
    public int read() throws IOException {
        int n = this.delegate.read();
        if (n >= 0) {
            this.callback.bytesNotification(1L);
        }
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.delegate.read(b, off, len);
        if (n >= 0) {
            this.callback.bytesNotification(n);
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        long l = this.delegate.skip(n);
        if (l >= 0L) {
            this.callback.bytesNotification(l);
        }
        return l;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

