/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.streams;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jppf.utils.JPPFBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleBuffersInputStream
extends InputStream {
    private static Logger log = LoggerFactory.getLogger(MultipleBuffersInputStream.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private List<JPPFBuffer> list;
    private JPPFBuffer currentBuffer = null;
    private int bufferIndex = -1;
    private int totalSize = 0;
    private boolean eofReached = false;

    public MultipleBuffersInputStream(JPPFBuffer ... buffers) {
        this.list = new ArrayList<JPPFBuffer>(buffers.length);
        for (JPPFBuffer b : buffers) {
            this.list.add(new JPPFBuffer(b.buffer, b.length));
            this.totalSize += b.length;
        }
    }

    public MultipleBuffersInputStream(List<JPPFBuffer> buffers) {
        this.list = new ArrayList<JPPFBuffer>(buffers.size());
        for (JPPFBuffer b : buffers) {
            this.list.add(new JPPFBuffer(b.buffer, b.length));
            this.totalSize += b.length;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.currentBuffer == null || this.currentBuffer.length - this.currentBuffer.pos < 1) {
            this.nextBuffer();
        }
        if (this.eofReached) {
            return -1;
        }
        int b = this.currentBuffer.buffer[this.currentBuffer.pos];
        ++this.currentBuffer.pos;
        if (traceEnabled) {
            log.trace("read one byte '" + b + "' from " + this);
        }
        return b < 0 ? b + 256 : b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eofReached) {
            return -1;
        }
        int count = 0;
        while (count < len) {
            if (this.currentBuffer == null || this.currentBuffer.length <= this.currentBuffer.pos) {
                this.nextBuffer();
            }
            if (this.eofReached) break;
            int n = Math.min(this.currentBuffer.length - this.currentBuffer.pos, len - count);
            System.arraycopy(this.currentBuffer.buffer, this.currentBuffer.pos, b, off + count, n);
            count += n;
            this.currentBuffer.pos += n;
        }
        return count;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void nextBuffer() {
        ++this.bufferIndex;
        if (this.bufferIndex >= this.list.size()) {
            this.eofReached = true;
            this.currentBuffer = null;
            return;
        }
        this.currentBuffer = this.list.get(this.bufferIndex);
        this.currentBuffer.pos = 0;
    }

    public JPPFBuffer getCurrentBuffer() {
        if (this.eofReached) {
            return null;
        }
        if (this.currentBuffer == null || this.currentBuffer.remainingFromPos() <= 0) {
            this.nextBuffer();
        }
        return this.currentBuffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("totalSize=").append(this.totalSize);
        sb.append(", nbBuffers=").append(this.list.size());
        sb.append(", bufferIndex=").append(this.bufferIndex);
        if (this.currentBuffer == null) {
            sb.append(", currentBuffer=null");
        } else {
            sb.append(", currentBuffer.pos=").append(this.currentBuffer.pos);
            sb.append(", currentBuffer.length=").append(this.currentBuffer.length);
        }
        sb.append(']');
        return sb.toString();
    }
}

