/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.pooling;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jppf.utils.pooling.ObjectPool;

public abstract class AbstractObjectPoolQueue<T>
implements ObjectPool<T> {
    protected final Queue<T> queue = new ConcurrentLinkedQueue<T>();

    @Override
    public T get() {
        T t = this.queue.poll();
        return t == null ? this.create() : t;
    }

    protected abstract T create();

    @Override
    public void put(T t) {
        this.queue.offer(t);
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }
}

