/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.pooling;

import org.jppf.utils.pooling.ObjectPool;

public abstract class AbstractObjectPoolImpl<T>
implements ObjectPool<T> {
    protected final LinkedData<T> data = new LinkedData();

    @Override
    public T get() {
        T t = this.data.get();
        return t == null ? this.create() : t;
    }

    protected abstract T create();

    @Override
    public void put(T t) {
        this.data.put(t);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    static class LinkedNode<E> {
        final E content;
        LinkedNode<E> prev = null;
        LinkedNode<E> next = null;

        LinkedNode(E content) {
            this.content = content;
        }
    }

    public static class LinkedData<E> {
        private LinkedNode<E> head = null;
        private LinkedNode<E> tail = null;
        int size = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(E content) {
            LinkedNode<E> node = new LinkedNode<E>(content);
            LinkedData linkedData = this;
            synchronized (linkedData) {
                if (this.tail != null) {
                    node.next = this.tail;
                    this.tail.prev = node;
                } else {
                    this.head = node;
                }
                this.tail = node;
                ++this.size;
            }
        }

        public synchronized E get() {
            if (this.head == null) {
                return null;
            }
            LinkedNode<E> res = this.head;
            if (res.prev == null) {
                this.tail = null;
                this.head = null;
            } else {
                this.head = res.prev;
                this.head.next = null;
            }
            --this.size;
            return res.content;
        }

        synchronized int size() {
            return this.size;
        }

        synchronized boolean isEmpty() {
            return this.head == null;
        }
    }
}

