/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.compilation;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.jppf.utils.compilation.CharSequenceSource;
import org.jppf.utils.compilation.CustomClassLoader;
import org.jppf.utils.compilation.ErrorReporter;
import org.jppf.utils.compilation.InMemoryFileManager;

public class SourceCompiler
implements Closeable {
    private final JavaCompiler compiler;
    private final StandardJavaFileManager toFileManager;
    private final InMemoryFileManager toMemoryManager;
    private final ErrorReporter errorReporter = new ErrorReporter();
    private CustomClassLoader classloader;

    public SourceCompiler() throws UnsupportedOperationException {
        this(SourceCompiler.class.getClassLoader());
    }

    public SourceCompiler(ClassLoader parentCL) throws UnsupportedOperationException {
        if (!SourceCompiler.isCompilerAvailable()) {
            throw new UnsupportedOperationException("no compiler is available for this platform");
        }
        this.compiler = ToolProvider.getSystemJavaCompiler();
        this.toFileManager = this.compiler.getStandardFileManager(null, null, null);
        this.toMemoryManager = new InMemoryFileManager<StandardJavaFileManager>(this.toFileManager);
        this.classloader = new CustomClassLoader(null, null, parentCL);
    }

    public void compileToFile(Map<String, CharSequence> sources, File classesDir) throws Exception {
        URL url;
        ArrayList<File> files = new ArrayList<File>();
        files.add(classesDir);
        this.toFileManager.setLocation(StandardLocation.CLASS_OUTPUT, files);
        Boolean b = this.compile(sources, this.toFileManager);
        if (b.booleanValue() && !this.classloader.hasURL(url = classesDir.toURI().toURL())) {
            this.classloader.addURL(url);
        }
    }

    public Map<String, byte[]> compileToMemory(Map<String, CharSequence> sources) throws Exception {
        Boolean b = this.compile(sources, this.toMemoryManager);
        Map<String, byte[]> result = this.toMemoryManager.getAllByteCodes();
        if (b.booleanValue()) {
            this.classloader.addClasses(result);
        }
        return result;
    }

    private Boolean compile(Map<String, CharSequence> sources, JavaFileManager fmgr) throws Exception {
        ArrayList<CharSequenceSource> sourceObjects = new ArrayList<CharSequenceSource>();
        for (Map.Entry<String, CharSequence> entry : sources.entrySet()) {
            sourceObjects.add(new CharSequenceSource(entry.getKey(), entry.getValue()));
        }
        this.errorReporter.clear();
        return this.compiler.getTask(null, fmgr, this.errorReporter, null, null, sourceObjects).call();
    }

    @Override
    public void close() throws IOException {
        this.toMemoryManager.close();
        this.classloader = null;
    }

    public List<Diagnostic> getDiagnostics() {
        return this.errorReporter.getErrors();
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public static boolean isCompilerAvailable() {
        return ToolProvider.getSystemJavaCompiler() != null;
    }
}

