/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.compilation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jppf.utils.compilation.BytecodeObject;

class InMemoryFileManager<M extends JavaFileManager>
extends ForwardingJavaFileManager<M> {
    private Map<String, BytecodeObject> classMap = new HashMap<String, BytecodeObject>();

    public InMemoryFileManager(M fileManager) {
        super(fileManager);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind == JavaFileObject.Kind.CLASS) {
            BytecodeObject bytecode = this.classMap.get(className);
            if (bytecode == null) {
                bytecode = new BytecodeObject(className);
                this.classMap.put(className, bytecode);
            }
            return bytecode;
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    public Map<String, byte[]> getAllByteCodes() {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (Map.Entry<String, BytecodeObject> entry : this.classMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getBytecode());
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.classMap.clear();
        super.close();
    }
}

