/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.compilation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Map;

class CustomClassLoader
extends URLClassLoader {
    private Map<String, byte[]> bytecodes = new Hashtable<String, byte[]>();

    public CustomClassLoader(URL[] urls, Map<String, byte[]> bytecodes, ClassLoader parent) {
        super(urls == null ? new URL[]{} : urls, parent);
        if (bytecodes != null) {
            this.bytecodes.putAll(bytecodes);
        }
    }

    public void addClasses(Map<String, byte[]> bytecodes) {
        this.bytecodes.putAll(bytecodes);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        byte[] bytes = this.bytecodes.get(name);
        c = bytes != null ? this.defineClass(name, bytes, 0, bytes.length) : super.findClass(name);
        return c;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        String className;
        byte[] bytes;
        if (name == null) {
            return null;
        }
        InputStream is = null;
        int idx = name.lastIndexOf(".class");
        if (idx >= 0 && (bytes = this.bytecodes.get(className = name.substring(0, idx).replace("/", "."))) != null) {
            is = new ByteArrayInputStream(bytes);
        }
        if (is == null) {
            is = super.getResourceAsStream(name);
        }
        return is;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public boolean hasURL(URL url) {
        if (url == null) {
            return false;
        }
        for (URL u : this.getURLs()) {
            if (!u.equals(url)) continue;
            return true;
        }
        return false;
    }
}

