/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftReferenceValuesMap<K, V>
extends AbstractMap<K, V> {
    private static Logger log = LoggerFactory.getLogger(SoftReferenceValuesMap.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    private ReferenceQueue<V> refQueue = new ReferenceQueue();
    private Map<K, SoftValue<K, V>> map = new HashMap<K, SoftValue<K, V>>();

    @Override
    public int size() {
        this.cleanup();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.cleanup();
        return this.map.isEmpty();
    }

    @Override
    public V get(Object key) {
        this.cleanup();
        SoftReference ref = this.map.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.cleanup();
        SoftReference ref = this.map.put(key, new SoftValue<K, V>(key, value, this.refQueue));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(Object key) {
        this.cleanup();
        SoftReference ref = this.map.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("This operation is not implemented");
    }

    private void cleanup() {
        SoftValue ref;
        while ((ref = (SoftValue)this.refQueue.poll()) != null) {
            Object key = ref.key;
            if (key == null) continue;
            if (traceEnabled) {
                log.trace("removing entry for key=" + key);
            }
            this.map.remove(key);
            ref.key = null;
        }
    }

    private static class SoftValue<K, V>
    extends SoftReference<V> {
        private K key;

        public SoftValue(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.key = key;
        }
    }
}

