/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.jppf.utils.collections.CollectionMap;

public abstract class AbstractCollectionMap<K, V>
implements Iterable<V>,
CollectionMap<K, V> {
    protected Map<K, Collection<V>> map = null;

    @Override
    public void putValue(K key, V value) {
        Collection<V> coll = this.map.get(key);
        if (coll == null) {
            coll = this.newCollection();
            this.map.put(key, coll);
        }
        coll.add(value);
    }

    @Override
    public boolean removeValue(K key, V value) {
        Collection<V> coll = this.map.get(key);
        if (coll != null) {
            boolean b = coll.remove(value);
            if (coll.isEmpty()) {
                this.map.remove(key);
            }
            return b;
        }
        return false;
    }

    @Override
    public void addValues(K key, V ... values) {
        Collection<V> coll = this.map.get(key);
        if (coll == null) {
            coll = this.newCollection();
            this.map.put(key, coll);
        }
        for (V value : values) {
            coll.add(value);
        }
    }

    @Override
    public int removeValues(K key, V ... values) {
        Collection<V> coll = this.map.get(key);
        if (coll != null) {
            int count = 0;
            for (V value : values) {
                if (!coll.remove(value)) continue;
                ++count;
            }
            if (coll.isEmpty()) {
                this.map.remove(key);
            }
            return count;
        }
        return 0;
    }

    @Override
    public Collection<V> removeKey(K key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        int result = 0;
        for (Map.Entry<K, Collection<V>> entry : this.map.entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(K key, V value) {
        Collection<V> coll = this.map.get(key);
        if (coll == null) {
            return false;
        }
        return coll.contains(value);
    }

    @Override
    public boolean contains(V value) {
        for (Map.Entry<K, Collection<V>> entry : this.map.entrySet()) {
            if (!entry.getValue().contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<V> iterator() {
        return new CollectionMapIterator();
    }

    @Override
    public Iterator<V> iterator(Lock lock) {
        return new CollectionMapIterator(lock);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    protected abstract Map<K, Collection<V>> createMap();

    protected abstract Collection<V> newCollection();

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Set<K> keySet() {
        return this.map == null ? null : this.map.keySet();
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.map == null ? null : this.map.entrySet();
    }

    private class CollectionMapIterator
    implements Iterator<V> {
        private Iterator<Map.Entry<K, Collection<V>>> entryIterator = null;
        private Iterator<V> listIterator = null;
        private final Lock lock;

        public CollectionMapIterator() {
            this(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CollectionMapIterator(Lock lock) {
            this.lock = lock;
            this.lock();
            try {
                this.entryIterator = AbstractCollectionMap.this.map.entrySet().iterator();
                if (this.entryIterator.hasNext()) {
                    this.listIterator = this.entryIterator.next().getValue().iterator();
                }
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            this.lock();
            try {
                boolean bl = this.entryIterator.hasNext() || this.listIterator != null && this.listIterator.hasNext();
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        @Override
        public V next() {
            this.lock();
            try {
                if (this.listIterator != null) {
                    if (this.listIterator.hasNext()) {
                        Object v = this.listIterator.next();
                        return v;
                    }
                    if (this.entryIterator.hasNext()) {
                        this.listIterator = this.entryIterator.next().getValue().iterator();
                        if (this.listIterator.hasNext()) {
                            Object v = this.listIterator.next();
                            return v;
                        }
                    }
                }
                throw new NoSuchElementException("no more element in this BundleIterator");
            }
            finally {
                this.unlock();
            }
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove() is not supported on a BundleIterator");
        }

        private void lock() {
            if (this.lock != null) {
                this.lock.lock();
            }
        }

        private void unlock() {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }
}

