/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.base64;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jppf.utils.base64.Base64;
import org.jppf.utils.base64.Base64Decoding;
import org.jppf.utils.base64.Base64Encoding;

public class Base64InputStream
extends FilterInputStream {
    private boolean encode;
    private int position;
    private byte[] buffer;
    private int bufferLength;
    private int numSigBytes;
    private int lineLength;
    private boolean breakLines;
    private int options;
    private byte[] decodabet;

    public Base64InputStream(InputStream in) {
        this(in, 0);
    }

    public Base64InputStream(InputStream in, int options) {
        super(in);
        this.options = options;
        this.breakLines = (options & 8) > 0;
        this.encode = (options & 1) > 0;
        this.bufferLength = this.encode ? 4 : 3;
        this.buffer = new byte[this.bufferLength];
        this.position = -1;
        this.lineLength = 0;
        this.decodabet = Base64.getDecodabet(options);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        if (this.position < 0) {
            if (this.encode) {
                int b;
                byte[] b3 = new byte[3];
                int numBinaryBytes = 0;
                for (int i = 0; i < 3 && (b = this.in.read()) >= 0; ++i) {
                    b3[i] = (byte)b;
                    ++numBinaryBytes;
                }
                if (numBinaryBytes <= 0) return -1;
                Base64Encoding.encode3to4(b3, 0, numBinaryBytes, this.buffer, 0, this.options);
                this.position = 0;
                this.numSigBytes = 4;
            } else {
                byte[] b4 = new byte[4];
                int i = 0;
                for (i = 0; i < 4; ++i) {
                    int b = 0;
                    while ((b = this.in.read()) >= 0 && this.decodabet[b & 0x7F] <= -5) {
                    }
                    if (b < 0) break;
                    b4[i] = (byte)b;
                }
                if (i == 4) {
                    this.numSigBytes = Base64Decoding.decode4to3(b4, 0, this.buffer, 0, this.options);
                    this.position = 0;
                } else {
                    if (i != 0) throw new IOException("Improperly padded Base64 input.");
                    return -1;
                }
            }
        }
        if (this.position < 0) throw new IOException("Error in Base64 code reading stream.");
        if (this.position >= this.numSigBytes) {
            return -1;
        }
        if (this.encode && this.breakLines && this.lineLength >= 76) {
            this.lineLength = 0;
            return 10;
        }
        ++this.lineLength;
        byte b = this.buffer[this.position++];
        if (this.position < this.bufferLength) return b & 0xFF;
        this.position = -1;
        return b & 0xFF;
    }

    @Override
    public int read(byte[] dest, int off, int len) throws IOException {
        int i;
        for (i = 0; i < len; ++i) {
            int b = this.read();
            if (b < 0) {
                if (i != 0) break;
                return -1;
            }
            dest[off + i] = (byte)b;
        }
        return i;
    }
}

