/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.base64;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.jppf.utils.base64.Base64;
import org.jppf.utils.base64.Base64OutputStream;

public final class Base64Encoding {
    static byte[] encode3to4(byte[] b4, byte[] threeBytes, int numSigBytes, int options) {
        Base64Encoding.encode3to4(threeBytes, 0, numSigBytes, b4, 0, options);
        return b4;
    }

    static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset, int options) {
        byte[] ALPHABET = Base64.getAlphabet(options);
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = ALPHABET[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                return destination;
            }
            case 1: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return destination;
            }
        }
        return destination;
    }

    public static void encode(ByteBuffer raw, ByteBuffer encoded) {
        byte[] raw3 = new byte[3];
        byte[] enc4 = new byte[4];
        while (raw.hasRemaining()) {
            int rem = Math.min(3, raw.remaining());
            raw.get(raw3, 0, rem);
            Base64Encoding.encode3to4(enc4, raw3, rem, 0);
            encoded.put(enc4);
        }
    }

    public static void encode(ByteBuffer raw, CharBuffer encoded) {
        byte[] raw3 = new byte[3];
        byte[] enc4 = new byte[4];
        while (raw.hasRemaining()) {
            int rem = Math.min(3, raw.remaining());
            raw.get(raw3, 0, rem);
            Base64Encoding.encode3to4(enc4, raw3, rem, 0);
            for (int i = 0; i < 4; ++i) {
                encoded.put((char)(enc4[i] & 0xFF));
            }
        }
    }

    public static String encodeObject(Serializable serializableObject) throws IOException {
        return Base64Encoding.encodeObject(serializableObject, 0);
    }

    public static String encodeObject(Serializable serializableObject, int options) throws IOException {
        if (serializableObject == null) {
            throw new NullPointerException("Cannot serialize a null object.");
        }
        ByteArrayOutputStream baos = null;
        OutputStream b64os = null;
        DeflaterOutputStream gzos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            b64os = new Base64OutputStream(baos, 1 | options);
            if ((options & 2) != 0) {
                gzos = new GZIPOutputStream(b64os);
                oos = new ObjectOutputStream(gzos);
            } else {
                oos = new ObjectOutputStream(b64os);
            }
            oos.writeObject(serializableObject);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception e) {}
            try {
                gzos.close();
            }
            catch (Exception e) {}
            try {
                b64os.close();
            }
            catch (Exception e) {}
            try {
                baos.close();
            }
            catch (Exception e) {}
        }
        try {
            return new String(baos.toByteArray(), "US-ASCII");
        }
        catch (UnsupportedEncodingException uue) {
            return new String(baos.toByteArray());
        }
    }

    public static String encodeBytes(byte[] source) {
        String encoded;
        block3: {
            encoded = null;
            try {
                encoded = Base64Encoding.encodeBytes(source, 0, source.length, 0);
            }
            catch (IOException ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)ex.getMessage());
            }
        }
        assert (encoded != null);
        return encoded;
    }

    public static String encodeBytes(byte[] source, int options) throws IOException {
        return Base64Encoding.encodeBytes(source, 0, source.length, options);
    }

    public static String encodeBytes(byte[] source, int off, int len) {
        String encoded;
        block3: {
            encoded = null;
            try {
                encoded = Base64Encoding.encodeBytes(source, off, len, 0);
            }
            catch (IOException ex) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)ex.getMessage());
            }
        }
        assert (encoded != null);
        return encoded;
    }

    public static String encodeBytes(byte[] source, int off, int len, int options) throws IOException {
        byte[] encoded = Base64Encoding.encodeBytesToBytes(source, off, len, options);
        try {
            return new String(encoded, "US-ASCII");
        }
        catch (UnsupportedEncodingException uue) {
            return new String(encoded);
        }
    }

    public static byte[] encodeBytesToBytes(byte[] source) {
        byte[] encoded;
        block2: {
            encoded = null;
            try {
                encoded = Base64Encoding.encodeBytesToBytes(source, 0, source.length, 0);
            }
            catch (IOException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("IOExceptions only come from GZipping, which is turned off: " + ex.getMessage()));
            }
        }
        return encoded;
    }

    public static byte[] encodeBytesToBytes(byte[] source, int off, int len, int options) throws IOException {
        if (source == null) {
            throw new NullPointerException("Cannot serialize a null array.");
        }
        if (off < 0) {
            throw new IllegalArgumentException("Cannot have negative offset: " + off);
        }
        if (len < 0) {
            throw new IllegalArgumentException("Cannot have length offset: " + len);
        }
        if (off + len > source.length) {
            throw new IllegalArgumentException(String.format("Cannot have offset of %d and length of %d with array of length %d", off, len, source.length));
        }
        if ((options & 2) != 0) {
            ByteArrayOutputStream baos = null;
            DeflaterOutputStream gzos = null;
            Base64OutputStream b64os = null;
            try {
                baos = new ByteArrayOutputStream();
                b64os = new Base64OutputStream(baos, 1 | options);
                gzos = new GZIPOutputStream(b64os);
                ((GZIPOutputStream)gzos).write(source, off, len);
                gzos.close();
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    gzos.close();
                }
                catch (Exception e) {}
                try {
                    b64os.close();
                }
                catch (Exception e) {}
                try {
                    baos.close();
                }
                catch (Exception e) {}
            }
            return baos.toByteArray();
        }
        boolean breakLines = (options & 8) != 0;
        int encLen = len / 3 * 4 + (len % 3 > 0 ? 4 : 0);
        if (breakLines) {
            encLen += encLen / 76;
        }
        byte[] outBuff = new byte[encLen];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            Base64Encoding.encode3to4(source, d + off, 3, outBuff, e, options);
            if (breakLines && (lineLength += 4) >= 76) {
                outBuff[e + 4] = 10;
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64Encoding.encode3to4(source, d + off, len - d, outBuff, e, options);
            e += 4;
        }
        if (e <= outBuff.length - 1) {
            byte[] finalOut = new byte[e];
            System.arraycopy(outBuff, 0, finalOut, 0, e);
            return finalOut;
        }
        return outBuff;
    }
}

