/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils.base64;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import org.jppf.utils.base64.Base64;
import org.jppf.utils.base64.Base64InputStream;
import org.jppf.utils.base64.Base64OutputStream;
import org.jppf.utils.streams.StreamConstants;

public final class Base64Decoding {
    static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset, int options) {
        if (source == null) {
            throw new NullPointerException("Source array was null.");
        }
        if (destination == null) {
            throw new NullPointerException("Destination array was null.");
        }
        if (srcOffset < 0 || srcOffset + 3 >= source.length) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d and still process four bytes.", source.length, srcOffset));
        }
        if (destOffset < 0 || destOffset + 2 >= destination.length) {
            throw new IllegalArgumentException(String.format("Destination array with length %d cannot have offset of %d and still store three bytes.", destination.length, destOffset));
        }
        byte[] DECODABET = Base64.getDecodabet(options);
        if (source[srcOffset + 2] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6 | DECODABET[source[srcOffset + 3]] & 0xFF;
        destination[destOffset] = (byte)(outBuff >> 16);
        destination[destOffset + 1] = (byte)(outBuff >> 8);
        destination[destOffset + 2] = (byte)outBuff;
        return 3;
    }

    public static byte[] decode(byte[] source) throws IOException {
        byte[] decoded = null;
        decoded = Base64Decoding.decode(source, 0, source.length, 0);
        return decoded;
    }

    public static byte[] decode(byte[] source, int off, int len, int options) throws IOException {
        if (source == null) {
            throw new NullPointerException("Cannot decode null source array.");
        }
        if (off < 0 || off + len > source.length) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d and process %d bytes.", source.length, off, len));
        }
        if (len == 0) {
            return StreamConstants.EMPTY_BYTES;
        }
        if (len < 4) {
            throw new IllegalArgumentException("Base64-encoded string must have at least four characters, but length specified was " + len);
        }
        byte[] DECODABET = Base64.getDecodabet(options);
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbiDecode = 0;
        for (i = off; i < off + len; ++i) {
            sbiDecode = DECODABET[source[i] & 0xFF];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = source[i];
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64Decoding.decode4to3(b4, 0, outBuff, outBuffPosn, options);
                b4Posn = 0;
                if (source[i] != 61) continue;
                break;
            }
            throw new IOException(String.format("Bad Base64 input character decimal %d in array position %d", source[i] & 0xFF, i));
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }

    public static byte[] decode(String s) throws IOException {
        return Base64Decoding.decode(s, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decode(String s, int options) throws IOException {
        int head;
        boolean dontGunzip;
        byte[] bytes;
        if (s == null) {
            throw new NullPointerException("Input string was null.");
        }
        try {
            bytes = s.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            bytes = s.getBytes();
        }
        bytes = Base64Decoding.decode(bytes, 0, bytes.length, options);
        boolean bl = dontGunzip = (options & 4) != 0;
        if (bytes != null && bytes.length >= 4 && !dontGunzip && 35615 == (head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00)) {
            ByteArrayInputStream bais = null;
            GZIPInputStream gzis = null;
            ByteArrayOutputStream baos = null;
            byte[] buffer = new byte[2048];
            int length = 0;
            try {
                baos = new ByteArrayOutputStream();
                bais = new ByteArrayInputStream(bytes);
                gzis = new GZIPInputStream(bais);
                while ((length = gzis.read(buffer)) >= 0) {
                    baos.write(buffer, 0, length);
                }
                bytes = baos.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    baos.close();
                }
                catch (Exception e) {}
                try {
                    gzis.close();
                }
                catch (Exception e) {}
                try {
                    bais.close();
                }
                catch (Exception e) {}
            }
        }
        return bytes;
    }

    public static Object decodeToObject(String encodedObject) throws IOException, ClassNotFoundException {
        return Base64Decoding.decodeToObject(encodedObject, 0, null);
    }

    public static Object decodeToObject(String encodedObject, int options, final ClassLoader loader) throws IOException, ClassNotFoundException {
        byte[] objBytes = Base64Decoding.decode(encodedObject, options);
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        Object obj = null;
        try {
            bais = new ByteArrayInputStream(objBytes);
            ois = loader == null ? new ObjectInputStream(bais) : new ObjectInputStream(bais){

                @Override
                public Class<?> resolveClass(ObjectStreamClass streamClass) throws IOException, ClassNotFoundException {
                    Class<?> c = Class.forName(streamClass.getName(), false, loader);
                    if (c == null) {
                        return super.resolveClass(streamClass);
                    }
                    return c;
                }
            };
            obj = ois.readObject();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        finally {
            try {
                bais.close();
            }
            catch (Exception e) {}
            try {
                ois.close();
            }
            catch (Exception e) {}
        }
        return obj;
    }

    public static void encodeToFile(byte[] dataToEncode, String filename) throws IOException {
        if (dataToEncode == null) {
            throw new NullPointerException("Data to encode was null.");
        }
        Base64OutputStream bos = null;
        try {
            bos = new Base64OutputStream(new FileOutputStream(filename), 1);
            bos.write(dataToEncode);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception e) {}
        }
    }

    public static void decodeToFile(String dataToDecode, String filename) throws IOException {
        Base64OutputStream bos = null;
        try {
            bos = new Base64OutputStream(new FileOutputStream(filename), 0);
            bos.write(dataToDecode.getBytes("US-ASCII"));
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception e) {}
        }
    }

    public static byte[] decodeFromFile(String filename) throws IOException {
        byte[] decodedData = null;
        FilterInputStream bis = null;
        try {
            File file = new File(filename);
            byte[] buffer = null;
            int length = 0;
            int numBytes = 0;
            if (file.length() > Integer.MAX_VALUE) {
                throw new IOException("File is too big for this convenience method (" + file.length() + " bytes).");
            }
            buffer = new byte[(int)file.length()];
            bis = new Base64InputStream(new BufferedInputStream(new FileInputStream(file)), 0);
            while ((numBytes = ((Base64InputStream)bis).read(buffer, length, 4096)) >= 0) {
                length += numBytes;
            }
            decodedData = new byte[length];
            System.arraycopy(buffer, 0, decodedData, 0, length);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {}
        }
        return decodedData;
    }

    public static String encodeFromFile(String filename) throws IOException {
        String encodedData = null;
        FilterInputStream bis = null;
        try {
            File file = new File(filename);
            byte[] buffer = new byte[Math.max((int)((double)file.length() * 1.4 + 1.0), 40)];
            int length = 0;
            int numBytes = 0;
            bis = new Base64InputStream(new BufferedInputStream(new FileInputStream(file)), 1);
            while ((numBytes = ((Base64InputStream)bis).read(buffer, length, 4096)) >= 0) {
                length += numBytes;
            }
            encodedData = new String(buffer, 0, length, "US-ASCII");
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {}
        }
        return encodedData;
    }

    public static void encodeFileToFile(String infile, String outfile) throws IOException {
        String encoded = Base64Decoding.encodeFromFile(infile);
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(outfile));
            out.write(encoded.getBytes("US-ASCII"));
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception ex) {}
        }
    }

    public static void decodeFileToFile(String infile, String outfile) throws IOException {
        byte[] decoded = Base64Decoding.decodeFromFile(infile);
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(outfile));
            out.write(decoded);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception ex) {}
        }
    }
}

