/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtils {
    private static Logger log = LoggerFactory.getLogger(VersionUtils.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static int buildNumber = -1;
    private static String ip = VersionUtils.getLocalIpAddress();
    private static final String VERSION_INFO = VersionUtils.readVersionInfo();

    private VersionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBuildNumber() {
        if (buildNumber < 0) {
            InputStream is = null;
            try {
                is = VersionUtils.class.getClassLoader().getResourceAsStream("build.number");
                if (is == null) {
                    buildNumber = 0;
                } else {
                    TypedProperties props = new TypedProperties();
                    props.load(is);
                    buildNumber = props.getInt("build.number");
                }
            }
            catch (Exception ignored) {
                buildNumber = 0;
            }
            finally {
                StreamUtils.close(is, log);
            }
        }
        return buildNumber;
    }

    public static void setBuildNumber(int buildNumber) {
        VersionUtils.buildNumber = buildNumber;
    }

    public static String getLocalIpAddress() {
        if (ip != null) {
            return ip;
        }
        try {
            InetAddress ip = InetAddress.getLocalHost();
            return ip.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String readVersionInfo() {
        String result = null;
        TypedProperties props = new TypedProperties();
        try {
            InputStream is = VersionUtils.class.getClassLoader().getResourceAsStream("META-INF/jppf-version.properties");
            props.load(is);
            StringBuilder sb = new StringBuilder();
            sb.append("JPPF version information: ");
            sb.append("Version: ").append(props.getString("version.number", ""));
            sb.append(", Build number: ").append(props.getString("build.number", ""));
            sb.append(", Build date: ").append(props.getString("build.date", ""));
            result = sb.toString();
        }
        catch (Exception e) {
            String s = "JPPF version information could not be determined";
            if (debugEnabled) {
                log.debug(s, (Throwable)e);
            } else {
                log.warn(s + ": " + ExceptionUtils.getMessage(e));
            }
            result = s;
        }
        return result;
    }

    public static String getVersionInformation() {
        return VERSION_INFO;
    }
}

