/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jppf.utils.FileUtils;
import org.jppf.utils.streams.StreamUtils;

public class TypedProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    public TypedProperties() {
    }

    public TypedProperties(Map<Object, Object> map) {
        if (map != null) {
            Set<Map.Entry<Object, Object>> entries = map.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                this.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defValue) {
        String val = this.getProperty(key);
        return val == null ? defValue : val;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defValue) {
        int intVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null) {
            try {
                intVal = Integer.parseInt(val.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return intVal;
    }

    public int getInt(String key, int defValue, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("min (" + min + ") must be <= max (" + max + ')');
        }
        int val = this.getInt(key, defValue);
        if (val > max) {
            val = max;
        }
        if (val < min) {
            val = min;
        }
        return val;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defValue) {
        long longVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null) {
            try {
                longVal = Long.parseLong(val.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return longVal;
    }

    public long getLong(String key, long defValue, long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("min (" + min + ") must be <= max (" + max + ')');
        }
        long val = this.getLong(key, defValue);
        if (val > max) {
            val = max;
        }
        if (val < min) {
            val = min;
        }
        return val;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defValue) {
        float floatVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null) {
            try {
                floatVal = Float.parseFloat(val.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return floatVal;
    }

    public float getFloat(String key, float defValue, float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("min (" + min + ") must be <= max (" + max + ')');
        }
        float val = this.getFloat(key, defValue);
        if (val > max) {
            val = max;
        }
        if (val < min) {
            val = min;
        }
        return val;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defValue) {
        double doubleVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null) {
            try {
                doubleVal = Double.parseDouble(val.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return doubleVal;
    }

    public double getDouble(String key, double defValue, double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("min (" + min + ") must be <= max (" + max + ')');
        }
        double val = this.getDouble(key, defValue);
        if (val > max) {
            val = max;
        }
        if (val < min) {
            val = min;
        }
        return val;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defValue) {
        boolean booleanVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null) {
            booleanVal = Boolean.valueOf(val.trim());
        }
        return booleanVal;
    }

    public char getChar(String key) {
        return this.getChar(key, ' ');
    }

    public char getChar(String key, char defValue) {
        char charVal = defValue;
        String val = this.getProperty(key, null);
        if (val != null && val.length() > 0) {
            charVal = val.charAt(0);
        }
        return charVal;
    }

    public TypedProperties getProperties(String key) {
        return this.getProperties(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypedProperties getProperties(String key, TypedProperties def) {
        String path = this.getString(key);
        TypedProperties res = new TypedProperties();
        InputStream is = null;
        try {
            is = FileUtils.getFileInputStream(path);
            res.load(is);
        }
        catch (IOException e) {
            TypedProperties typedProperties = def;
            return typedProperties;
        }
        finally {
            StreamUtils.closeSilent(is);
        }
        return res;
    }

    public InetAddress getInetAddress(String key) {
        return this.getInetAddress(key, null);
    }

    public InetAddress getInetAddress(String key, InetAddress def) {
        String val = this.getString(key);
        if (val == null) {
            return def;
        }
        try {
            return InetAddress.getByName(val);
        }
        catch (UnknownHostException e) {
            return def;
        }
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<Object, Object>> entries = this.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            sb.append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public void loadString(String source) throws IOException {
        if (source == null) {
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(source.getBytes());
        this.load(bais);
        bais.close();
    }

    public int getAndReplaceInt(String name1, String name2, int def, boolean doRemove) {
        int value = this.getInt(name1, -1);
        if (value < 0) {
            value = this.getInt(name2, def);
            this.setProperty(name1, "" + value);
        }
        if (doRemove) {
            this.remove(name2);
        }
        return value;
    }

    public String getAndReplaceString(String name1, String name2, String def, boolean doRemove) {
        String value = this.getString(name1, null);
        if (value == null) {
            value = this.getString(name2, def);
            this.setProperty(name1, "" + value);
        }
        if (doRemove) {
            this.remove(name2);
        }
        return value;
    }
}

