/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class TraversalList<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<E> list;
    private int position = -1;
    private String toStr = null;

    public TraversalList() {
        this.list = new LinkedList();
        this.toStr = this.list.toString();
    }

    public TraversalList(List<E> list) {
        this.list = list;
        this.toStr = list.toString();
    }

    public void add(E element) {
        this.list.add(element);
        this.toStr = this.list.toString();
    }

    public E getFirst() {
        return this.list.get(0);
    }

    public E getLast() {
        return this.list.get(this.list.size() - 1);
    }

    public void incPosition() {
        if (this.position >= this.list.size() - 1) {
            throw new ArrayIndexOutOfBoundsException("position " + (this.position + 1) + " larger than " + this.list.size());
        }
        ++this.position;
    }

    public void decPosition() {
        if (this.position <= 0) {
            throw new ArrayIndexOutOfBoundsException("position " + (this.position + 1) + " less than 0");
        }
        --this.position;
    }

    public List<E> getList() {
        return this.list;
    }

    public int getPosition() {
        return this.list.isEmpty() ? -1 : this.position;
    }

    public void setPosition(int pos) {
        if (this.list.isEmpty()) {
            throw new IndexOutOfBoundsException("list is empty");
        }
        if (pos < 0) {
            throw new IndexOutOfBoundsException("value " + pos + " is negative");
        }
        if (pos >= this.list.size()) {
            throw new IndexOutOfBoundsException("value " + pos + " larger than " + (this.list.size() - 1));
        }
        this.position = pos;
    }

    public E getCurrentElement() {
        return this.list.get(this.position);
    }

    public int size() {
        return this.list.size();
    }

    public boolean contains(E element) {
        return this.list.contains(element);
    }

    public String toString() {
        return this.toStr;
    }

    public String asString() {
        return this.toStr;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TraversalList)) {
            return false;
        }
        return this.list.equals(((TraversalList)obj).list);
    }

    public int hashCode() {
        return this.list.hashCode();
    }
}

